/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.model.entity;

import com.aetherteam.aether.entity.monster.dungeon.Sentry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.zepalesque.redux.capability.animation.sentry.SentryAnimation;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.math.EasingUtil;

public class SentryReduxModel<T extends Sentry>
extends EntityModel<T> {
    private final ModelPart main;
    private final ModelPart spring_part;
    public final ModelPart spring_control;
    public final ModelPart spring_main;

    public SentryReduxModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.spring_part = this.main.m_171324_("spring_part");
        this.spring_main = this.spring_part.m_171324_("spring_main");
        this.spring_control = this.spring_part.m_171324_("spring_control");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -2.0f, -6.5f, 12.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.5f));
        PartDefinition spring_part = main.m_171599_("spring_part", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition spring_control = spring_part.m_171599_("spring_control", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-6.0f, -3.0f, -6.5f, 12.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spring_main = spring_part.m_171599_("spring_main", CubeListBuilder.m_171558_().m_171514_(26, 36).m_171488_(-3.0f, -11.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        SentryAnimation.get(entity).ifPresent(anim -> {
            byte jump = anim.getJumpAnim();
            int prevJump = jump > 1 && anim.getPrevJumpAnim() == 0 ? 10 : anim.getPrevJumpAnim();
            float trueJump = Mth.m_14179_((float)(ageInTicks % 1.0f), (float)prevJump, (float)jump);
            float progress = (10.0f - trueJump) / 10.0f;
            if (progress <= 0.83f) {
                float progressEase = progress / 0.83f;
                this.spring_control.f_104201_ = EasingUtil.Quadratic.out(progressEase) * 10.0f;
                this.spring_main.f_104201_ = EasingUtil.Quadratic.out(progressEase) * 8.0f - 1.0f;
            } else {
                float progressEase = (progress - 0.83f) / 0.17f;
                this.spring_control.f_104201_ = EasingUtil.Cubic.out(progressEase) * -10.0f + 10.0f;
                this.spring_main.f_104201_ = EasingUtil.Cubic.out(progressEase) * -8.0f + 10.0f - 1.0f;
            }
        });
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (((Boolean)ReduxConfig.CLIENT.sentry_model_upgrade.get()).booleanValue()) {
            this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

