/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.layer.entity;

import com.aetherteam.aether.client.renderer.entity.MoaRenderer;
import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.zepalesque.redux.capability.animation.moa.MoaAnimation;
import net.zepalesque.redux.client.render.entity.model.entity.MoaReduxModel;
import net.zepalesque.redux.client.render.util.MoaUtils;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.MoaModelType;
import net.zepalesque.redux.util.math.MathUtil;

public class MoaReduxLayer
extends RenderLayer<Moa, MoaModel> {
    protected final MoaRenderer parent;
    private final MoaReduxModel legacy;
    private final MoaReduxModel legacyTalons;
    private final MoaReduxModel refreshed;
    private static final Map<ResourceLocation, ResourceLocation> TRANSLATION_MAP = new HashMap<ResourceLocation, ResourceLocation>();

    public MoaReduxLayer(MoaRenderer entityRenderer, MoaReduxModel legacy, MoaReduxModel legacyTalons, MoaReduxModel refreshed) {
        super((RenderLayerParent)entityRenderer);
        this.legacy = legacy;
        this.legacyTalons = legacyTalons;
        this.refreshed = refreshed;
        this.parent = entityRenderer;
    }

    public void render(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, Moa moa, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (MoaUtils.useNewModel(moa)) {
            boolean useOriginalLegs;
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.5, 0.0);
            boolean bl = useOriginalLegs = ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.refreshed;
            MoaReduxModel model = ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.legacy_toes ? this.legacy : (ReduxConfig.CLIENT.moa_model_type.get() == MoaModelType.legacy_talons ? this.legacyTalons : this.refreshed);
            model.neck.f_104204_ = ((MoaModel)this.m_117386_()).head.f_104204_ * 0.333f;
            model.neck.f_104203_ = ((MoaModel)this.m_117386_()).head.f_104203_ * 0.125f;
            model.head_part.f_104204_ = ((MoaModel)this.m_117386_()).head.f_104204_ * 0.667f;
            model.head_part.f_104203_ = ((MoaModel)this.m_117386_()).head.f_104203_ * 0.875f;
            model.jaw.f_104203_ = ((MoaModel)this.m_117386_()).jaw.f_104203_;
            float breathe = MathUtil.breathe((Entity)moa, partialTicks);
            if (moa.f_20916_ > 0 && (float)moa.f_20916_ - partialTicks > 0.0f) {
                int hit = moa.f_20917_ - moa.f_20916_;
                float hitSmooth = (float)hit + partialTicks;
                float baseRot = hitSmooth >= (float)moa.f_20917_ * 0.25f + 0.0f ? -Mth.m_14089_((float)(0.41887906f * (hitSmooth + 5.0f))) + 1.0f : -Mth.m_14089_((float)(1.2566371f * hitSmooth));
                float rot = baseRot * 0.3926991f;
                model.neck_hurtanim.f_104203_ = 0.6667f * rot;
                model.body_additions.f_104203_ = 0.3333f * rot + breathe;
                model.head_hurtanim.f_104203_ = -rot;
            } else {
                model.neck_hurtanim.f_104203_ = breathe * 0.5f;
                model.head_hurtanim.f_104203_ = -1.5f * breathe;
                model.neck_hurtanim.f_104204_ = 0.0f;
                model.head_hurtanim.f_104204_ = 0.0f;
                model.body_additions.f_104203_ = breathe;
            }
            model.middle_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.0f);
            model.left_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.6667f);
            model.right_feather.f_104203_ = MathUtil.breatheBase((Entity)moa, partialTicks, 0.1f, 0.1f, 0.3333f);
            model.wing_1.f_104203_ = ((MoaModel)this.m_117386_()).rightWing.f_104203_ * 0.625f + 1.5707964f - 0.2617889f;
            model.z_rot_wing_1.f_104205_ = ((MoaModel)this.m_117386_()).rightWing.f_104204_ * 0.875f + 0.2617889f - breathe;
            model.wing_2.f_104203_ = ((MoaModel)this.m_117386_()).leftWing.f_104203_ * 0.625f + 1.5707964f - 0.2617889f;
            model.z_rot_wing_2.f_104205_ = ((MoaModel)this.m_117386_()).leftWing.f_104204_ * 0.875f - 0.2617889f + breathe;
            model.feathers_3_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : MathUtil.degToRad(-45.0f)) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.0f);
            model.feathers_2_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : MathUtil.degToRad(-30.0f)) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.3333f);
            model.feathers_1_wing1.f_104203_ = (moa.isEntityOnGround() ? 0.0f : MathUtil.degToRad(-25.0f)) - MathUtil.breatheBase((Entity)moa, partialTicks, 0.025f, 0.1f, 0.6667f);
            model.feathers_3_wing2.f_104203_ = model.feathers_3_wing1.f_104203_;
            model.feathers_2_wing2.f_104203_ = model.feathers_2_wing1.f_104203_;
            model.feathers_1_wing2.f_104203_ = model.feathers_1_wing1.f_104203_;
            if ((!moa.isSitting() || !moa.isEntityOnGround() && moa.isSitting()) && !useOriginalLegs) {
                MoaAnimation moaAnimation;
                float progress;
                model.leg1.f_233556_ = false;
                model.leg2.f_233556_ = false;
                float f = progress = moa.isEntityOnGround() ? 0.0f : 1.0f;
                if (MoaAnimation.get(moa).isPresent() && (moaAnimation = (MoaAnimation)MoaAnimation.get(moa).orElse(null)) != null) {
                    progress = Mth.m_14179_((float)partialTicks, (float)moaAnimation.getPrevLegAnim(), (float)moaAnimation.getLegAnim()) * 0.2f;
                }
                float left = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
                float right = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                model.leg1.f_104203_ = MathUtil.costrp(progress, left * 0.8f, MathUtil.degToRad(15.0f));
                model.leg2.f_104203_ = MathUtil.costrp(progress, right * 0.8f, MathUtil.degToRad(15.0f));
                model.lower_leg1.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos(limbSwing * 0.6662f), -left) * 0.3333f * limbSwingAmount, MathUtil.degToRad(25.0f));
                model.lower_leg2.f_104203_ = MathUtil.costrp(progress, -MathUtil.returnZeroWhenNegative(MathUtil.animCos((float)((double)(limbSwing * 0.6662f) + Math.PI)), -right) * 0.333f * limbSwingAmount, MathUtil.degToRad(25.0f));
                model.toes_stepanim_leg1.f_104203_ = MathUtil.costrp(progress, -model.lower_leg1.f_104203_ * 0.3333f, 0.0f);
                model.toes_stepanim_leg2.f_104203_ = MathUtil.costrp(progress, -model.lower_leg2.f_104203_ * 0.3333f, 0.0f);
                model.toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, MathUtil.degToRad(10.0f));
                model.toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, MathUtil.degToRad(10.0f));
                model.back_toes_leg1.f_104203_ = MathUtil.costrp(progress, 0.0f, MathUtil.degToRad(-75.0f));
                model.back_toes_leg2.f_104203_ = MathUtil.costrp(progress, 0.0f, MathUtil.degToRad(-75.0f));
            } else {
                model.leg1.f_233556_ = true;
                model.leg2.f_233556_ = true;
            }
            model.setupAnim(moa, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (Minecraft.m_91087_().f_91074_ != null && !moa.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
                ResourceLocation feathersLoc = this.getTextureLocation(moa);
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)feathersLoc));
                model.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)moa, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            poseStack.m_85849_();
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(Moa moa) {
        ResourceLocation key = this.parent.getTextureLocation(moa);
        if (TRANSLATION_MAP.containsKey(key)) {
            return TRANSLATION_MAP.get(key);
        }
        ResourceLocation translated = new ResourceLocation(key.m_135827_(), key.m_135815_().replace(".png", "_redux.png"));
        TRANSLATION_MAP.put(key, translated);
        return translated;
    }
}

