/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render;

import com.aetherteam.aether.client.renderer.accessory.PendantRenderer;
import com.aetherteam.aether.client.renderer.entity.CockatriceRenderer;
import com.aetherteam.aether.client.renderer.entity.FlyingCowRenderer;
import com.aetherteam.aether.client.renderer.entity.MimicRenderer;
import com.aetherteam.aether.client.renderer.entity.MoaRenderer;
import com.aetherteam.aether.client.renderer.entity.PhygRenderer;
import com.aetherteam.aether.client.renderer.entity.SentryRenderer;
import com.aetherteam.aether.client.renderer.entity.SheepuffRenderer;
import com.aetherteam.aether.client.renderer.entity.model.CockatriceModel;
import com.aetherteam.aether.client.renderer.entity.model.MimicModel;
import com.aetherteam.aether.client.renderer.entity.model.SheepuffModel;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.aetherteam.aether.entity.monster.dungeon.Sentry;
import com.aetherteam.aether.entity.passive.FlyingCow;
import com.aetherteam.aether.entity.passive.Phyg;
import com.aetherteam.aether.entity.passive.Sheepuff;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.blockentity.ReduxBlockEntityTypes;
import net.zepalesque.redux.client.render.ReduxModelLayers;
import net.zepalesque.redux.client.render.bewlr.ReduxBEWLR;
import net.zepalesque.redux.client.render.blockentity.SkyrootChestMimicRenderer;
import net.zepalesque.redux.client.render.blockentity.SkyrootChestRenderer;
import net.zepalesque.redux.client.render.entity.BlightbunnyRenderer;
import net.zepalesque.redux.client.render.entity.DarkSwetRenderer;
import net.zepalesque.redux.client.render.entity.EmberRenderer;
import net.zepalesque.redux.client.render.entity.InfusedVeridiumDartRenderer;
import net.zepalesque.redux.client.render.entity.ShimmercowRenderer;
import net.zepalesque.redux.client.render.entity.SkyrootMimicRenderer;
import net.zepalesque.redux.client.render.entity.SolarEmblemRenderer;
import net.zepalesque.redux.client.render.entity.ThrownSpearRenderer;
import net.zepalesque.redux.client.render.entity.VampireAmuletRenderer;
import net.zepalesque.redux.client.render.entity.VanillaSwetRenderer;
import net.zepalesque.redux.client.render.entity.VeridiumArrowRenderer;
import net.zepalesque.redux.client.render.entity.VolatileFireCrystalRenderer;
import net.zepalesque.redux.client.render.entity.layer.entity.CockatriceReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.FlyingCowReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.MimicReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.MoaReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.PhygReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.SentryReduxLayer;
import net.zepalesque.redux.client.render.entity.layer.entity.SheepuffReduxLayer;
import net.zepalesque.redux.client.render.entity.misc.ReduxBoatRenderer;
import net.zepalesque.redux.client.render.entity.model.PinModel;
import net.zepalesque.redux.client.render.entity.model.SpearModel;
import net.zepalesque.redux.client.render.entity.model.entity.BlightbunnyModel;
import net.zepalesque.redux.client.render.entity.model.entity.CockatriceReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.CubeModel;
import net.zepalesque.redux.client.render.entity.model.entity.FlyingCowReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.MimicReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.MoaReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.PhygReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.SentryReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.SheepuffReduxModel;
import net.zepalesque.redux.client.render.entity.model.entity.ShimmercowModel;
import net.zepalesque.redux.entity.ReduxEntityTypes;
import net.zepalesque.redux.item.ReduxItems;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="aether_redux", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxRenderers {
    public static final Lazy<BlockEntityWithoutLevelRenderer> bewlr = Lazy.of(ReduxBEWLR::new);
    public static final IClientItemExtensions itemProp = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return (BlockEntityWithoutLevelRenderer)bewlr.get();
        }
    };

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        for (WoodHandler woodHandler : Redux.WoodHandlers.WOOD_HANDLERS) {
            event.registerBlockEntityRenderer((BlockEntityType)woodHandler.signEntity.get(), SignRenderer::new);
            event.registerEntityRenderer((EntityType)woodHandler.boatEntity.get(), context -> new ReduxBoatRenderer(context, false, woodHandler.woodName));
            event.registerEntityRenderer((EntityType)woodHandler.chestBoatEntity.get(), context -> new ReduxBoatRenderer(context, true, woodHandler.woodName));
        }
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.VANILLA_SWET.get(), VanillaSwetRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.DARK_SWET.get(), DarkSwetRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.INFUSED_VERIDIUM_DART.get(), InfusedVeridiumDartRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.VERIDIUM_DART.get(), VeridiumArrowRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.VOLATILE_FIRE_CRYSTAL.get(), VolatileFireCrystalRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.EMBER.get(), EmberRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.THROWN_SPEAR.get(), ThrownSpearRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.SHIMMERCOW.get(), ShimmercowRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.BLIGHTBUNNY.get(), BlightbunnyRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ReduxBlockEntityTypes.SKYROOT_CHEST.get(), SkyrootChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ReduxBlockEntityTypes.TRAPPED_SKYROOT_CHEST.get(), SkyrootChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ReduxBlockEntityTypes.SKYROOT_CHEST_MIMIC.get(), SkyrootChestMimicRenderer::new);
        event.registerEntityRenderer((EntityType)ReduxEntityTypes.SKYROOT_MIMIC.get(), SkyrootMimicRenderer::new);
    }

    public static void registerCuriosRenderers() {
        CuriosRendererRegistry.register((Item)((Item)ReduxItems.VAMPIRE_AMULET.get()), VampireAmuletRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ReduxItems.GRAND_VICTORY_MEDAL.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)ReduxItems.SOLAR_EMBLEM.get()), SolarEmblemRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ReduxModelLayers.MOA_OLD, MoaReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.MOA_TALONS, MoaReduxModel::createTalonsLayer);
        event.registerLayerDefinition(ReduxModelLayers.MOA_REFRESHED, MoaReduxModel::createRefreshedLayer);
        event.registerLayerDefinition(ReduxModelLayers.COCKATRICE_OLD, CockatriceReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.COCKATRICE_REFRESHED, CockatriceReduxModel::createRefreshedLayer);
        event.registerLayerDefinition(ReduxModelLayers.GLIMMERCOW, ShimmercowModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.MIMIC, MimicReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.SENTRY, SentryReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.BLIGHTBUNNY, BlightbunnyModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.SPEAR, SpearModel::createLayer);
        event.registerLayerDefinition(ReduxModelLayers.SHEEPUFF, SheepuffReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.PHYG, PhygReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.FLYING_COW, FlyingCowReduxModel::createBodyLayer);
        event.registerLayerDefinition(ReduxModelLayers.PIN, PinModel::createLayer);
        event.registerLayerDefinition(ReduxModelLayers.SKYROOT_CHEST_MIMIC, ChestRenderer::m_173608_);
        event.registerLayerDefinition(ReduxModelLayers.SKYROOT_MIMIC, MimicModel::createBodyLayer);
        if (!FMLLoader.isProduction()) {
            event.registerLayerDefinition(ReduxModelLayers.CUBE, CubeModel::create);
        }
    }

    @SubscribeEvent
    public static void addRenderLayers(EntityRenderersEvent.AddLayers event) {
        Minecraft mc = Minecraft.m_91087_();
        for (EntityRenderer renderer : mc.m_91290_().f_114362_.values()) {
            Object mimic;
            if (renderer instanceof MoaRenderer) {
                MoaRenderer moa = (MoaRenderer)renderer;
                moa.m_115326_((RenderLayer)new MoaReduxLayer(moa, new MoaReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.MOA_OLD)), new MoaReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.MOA_TALONS)), new MoaReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.MOA_REFRESHED))));
            }
            if (renderer instanceof MimicRenderer) {
                mimic = (MimicRenderer)renderer;
                mimic.m_115326_((RenderLayer)new MimicReduxLayer((RenderLayerParent<Mimic, MimicModel>)mimic, new MimicReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.MIMIC))));
            }
            if (renderer instanceof SkyrootMimicRenderer) {
                mimic = (SkyrootMimicRenderer)renderer;
                mimic.m_115326_((RenderLayer)new MimicReduxLayer((RenderLayerParent<Mimic, MimicModel>)mimic, new MimicReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.MIMIC))));
            }
            if (renderer instanceof CockatriceRenderer) {
                CockatriceRenderer cockatrice = (CockatriceRenderer)renderer;
                cockatrice.m_115326_((RenderLayer)new CockatriceReduxLayer((RenderLayerParent<Cockatrice, CockatriceModel>)cockatrice, new CockatriceReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.COCKATRICE_OLD)), new CockatriceReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.COCKATRICE_REFRESHED))));
            }
            if (renderer instanceof SentryRenderer) {
                SentryRenderer sentry = (SentryRenderer)renderer;
                sentry.m_115326_((RenderLayer)new SentryReduxLayer((RenderLayerParent<Sentry, SlimeModel<Sentry>>)sentry, new SentryReduxModel<Sentry>(mc.m_167973_().m_171103_(ReduxModelLayers.SENTRY))));
            }
            if (renderer instanceof SheepuffRenderer) {
                SheepuffRenderer sheepuff = (SheepuffRenderer)renderer;
                sheepuff.m_115326_((RenderLayer)new SheepuffReduxLayer((RenderLayerParent<Sheepuff, SheepuffModel>)sheepuff, new SheepuffReduxModel(mc.m_167973_().m_171103_(ReduxModelLayers.SHEEPUFF))));
            }
            if (renderer instanceof PhygRenderer) {
                PhygRenderer phyg = (PhygRenderer)renderer;
                phyg.m_115326_((RenderLayer)new PhygReduxLayer((RenderLayerParent<Phyg, PigModel<Phyg>>)phyg, new PhygReduxModel<Phyg>(mc.m_167973_().m_171103_(ReduxModelLayers.PHYG))));
            }
            if (!(renderer instanceof FlyingCowRenderer)) continue;
            FlyingCowRenderer cow = (FlyingCowRenderer)renderer;
            cow.m_115326_((RenderLayer)new FlyingCowReduxLayer((RenderLayerParent<FlyingCow, CowModel<FlyingCow>>)cow, new FlyingCowReduxModel<FlyingCow>(mc.m_167973_().m_171103_(ReduxModelLayers.FLYING_COW))));
        }
    }
}

