/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.capability.player.AdrenalineModule;
import net.zepalesque.redux.capability.player.ReduxPlayer;

@Mod.EventBusSubscriber(modid="aether_redux", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxOverlays {
    private static final ResourceLocation ADRENALINE_OVERLAY = Redux.locate("textures/blur/adrenaline_vignette.png");

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("adrenaline_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                ReduxPlayer.get((Player)player).ifPresent(reduxPlayer -> ReduxOverlays.renderAdrenalineOverlay(pStack, minecraft, window, reduxPlayer.getAdrenalineModule(), partialTicks));
            }
        });
    }

    private static void renderAdrenalineOverlay(PoseStack guiGraphics, Minecraft minecraft, Window window, AdrenalineModule module, float partialTicks) {
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        float alpha = module.getTransparency(partialTicks);
        ReduxOverlays.renderVignette(guiGraphics, window, effectScale, alpha, ADRENALINE_OVERLAY);
    }

    private static void renderVignette(PoseStack poseStack, Window window, double effectScale, float alpha, ResourceLocation resource) {
        poseStack.m_85836_();
        alpha = (float)((double)alpha * Math.sqrt(effectScale));
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)0, (int)0, (int)-90, (float)0.0f, (float)0.0f, (int)window.m_85445_(), (int)window.m_85446_(), (int)window.m_85445_(), (int)window.m_85446_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        poseStack.m_85849_();
    }
}

