/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.particle;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.zepalesque.redux.util.math.MathUtil;

@OnlyIn(value=Dist.CLIENT)
public class FallingLeafParticle
extends TextureSheetParticle {
    private float rotSpeed = (float)Math.toRadians(this.f_107223_.m_188499_() ? -30.0 : 30.0);
    private final float particleRandom;
    private final float spinAcceleration;
    private float onGroundTime = 40.0f;
    protected static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.m_144952_((double)100.0);

    protected FallingLeafParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        float f;
        this.f_107204_ = this.f_107231_ = MathUtil.degToRad(this.f_107223_.m_188501_() * 360.0f);
        this.particleRandom = this.f_107223_.m_188501_();
        this.spinAcceleration = (float)Math.toRadians(this.f_107223_.m_188499_() ? -5.0 : 5.0);
        this.f_107225_ = 300;
        this.f_107226_ = 7.5E-4f;
        this.f_107663_ = f = this.f_107223_.m_188499_() ? 0.05f : 0.075f;
        this.m_107250_(f, f);
        this.f_172258_ = 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
        if (!this.f_107220_) {
            float f = 300 - this.f_107225_;
            float f1 = Math.min(f / 300.0f, 1.0f);
            double d0 = Math.cos(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            double d1 = Math.sin(Math.toRadians(this.particleRandom * 60.0f)) * 2.0 * Math.pow(f1, 1.25);
            this.f_107204_ = this.f_107231_;
            if (!this.f_107218_ && !(this.onGroundTime < 40.0f)) {
                this.f_107215_ += d0 * (double)0.0025f;
                this.f_107217_ += d1 * (double)0.0025f;
                this.f_107216_ -= (double)this.f_107226_;
                this.rotSpeed += this.spinAcceleration / 20.0f;
                this.f_107231_ += this.rotSpeed / 20.0f;
            }
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if ((this.f_107218_ || this.onGroundTime < 40.0f) && this.f_107225_ < 299) {
                this.onGroundTime -= 1.0f;
                this.f_107215_ = 0.0;
                this.f_107217_ = 0.0;
            }
            if (this.onGroundTime < 0.0f) {
                this.m_107274_();
            }
            if (this.onGroundTime <= 20.0f) {
                this.f_107230_ = this.onGroundTime / 20.0f;
            }
            if (!this.f_107220_) {
                this.f_107215_ *= (double)this.f_172258_;
                this.f_107216_ *= (double)this.f_172258_;
                this.f_107217_ *= (double)this.f_172258_;
            }
        }
    }

    public void m_6257_(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vec3.f_82479_;
            y = vec3.f_82480_;
            z = vec3.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = d1 != y && d1 < 0.0;
        if (d0 != x) {
            this.f_107215_ = 0.0;
        }
        if (d2 != z) {
            this.f_107217_ = 0.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSetIn) {
            this.spriteSet = spriteSetIn;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLeafParticle leavesParticle = new FallingLeafParticle(worldIn, x, y, z);
            leavesParticle.m_108335_(this.spriteSet);
            return leavesParticle;
        }
    }
}

