/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.gui.component.menu;

import com.aetherteam.aether.client.gui.component.Builder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.gui.screen.menu.ReduxTitleScreen;

public class ReduxMenuButton
extends Button {
    private static final ResourceLocation AETHER_WIDGETS = Redux.locate("textures/gui/title/buttons.png");
    private static final int BUTTON_WIDTH = 400;
    private static final int BUTTON_HEIGHT = 40;
    private static final int BUTTON_SEPARATION = 50;
    private static final int INITIAL_X_OFFSET = 16;
    private static final int INITIAL_Y_OFFSET = 100;
    private static final int TEXTURE_SIZE = 512;
    private final ReduxTitleScreen screen;
    public final int originalX;
    public final int originalY;
    public final int originalWidth;
    public final int originalHeight;
    public int hoverOffset;
    public int buttonCountOffset;
    public boolean serverButton;

    public ReduxMenuButton(ReduxTitleScreen screen, Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.tooltip);
        this.screen = screen;
        this.originalX = this.f_93620_;
        this.originalY = this.f_93621_;
        this.originalWidth = this.m_5711_();
        this.originalHeight = this.m_93694_();
        this.hoverOffset = 0;
    }

    public ReduxMenuButton(ReduxTitleScreen screen, Button oldButton) {
        this(screen, new Builder(oldButton.m_6035_(), button -> oldButton.m_5691_()).bounds(oldButton.f_93620_, oldButton.f_93621_, oldButton.m_5711_(), oldButton.m_93694_()));
        oldButton.f_93624_ = false;
        oldButton.f_93623_ = false;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int i = this.getTextureY();
        float scale = ReduxTitleScreen.getScale(this.screen, minecraft);
        this.f_93620_ = 16;
        this.f_93621_ = (int)(100.0f / scale + (float)this.buttonCountOffset * (50.0f / scale));
        this.m_93674_((int)(400.0f / scale));
        this.setHeight((int)(40.0f / scale));
        RenderSystem.m_157456_((int)0, (ResourceLocation)AETHER_WIDGETS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69482_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + this.hoverOffset), (int)this.f_93621_, (float)0.0f, (float)Mth.m_14167_((float)((float)i / scale)), (int)this.m_5711_(), (int)this.m_93694_(), (int)((int)(512.0f / scale)), (int)((int)(512.0f / scale)));
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
        poseStack.m_85836_();
        float textScale = ReduxMenuButton.getTextScale(this.screen, minecraft);
        float textX = (float)this.f_93620_ + 35.0f * textScale + (float)this.hoverOffset;
        float textY = (float)this.f_93621_ + ((float)this.f_93619_ - 8.0f * textScale) / 2.0f;
        poseStack.m_85837_((double)textX, (double)textY, 0.0);
        poseStack.m_85841_(textScale, textScale, textScale);
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)font, (Component)this.m_6035_(), (int)0, (int)0, (int)(this.getTextColor(mouseX, mouseY) | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        poseStack.m_85849_();
    }

    public static float getTextScale(ReduxTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        float elementScale = ReduxTitleScreen.getScale(screen, minecraft);
        float elementPixelWidth = (int)((float)guiScale / elementScale);
        float textPixelWidth = elementPixelWidth + 2.0f;
        if (elementPixelWidth <= 1.0f) {
            textPixelWidth = 2.0f;
        }
        return textPixelWidth / (float)guiScale;
    }

    private int getTextureY() {
        int i = 1;
        if (!this.m_142518_()) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return i * 40;
    }

    public int getTextColor(int mouseX, int mouseY) {
        if (!this.serverButton) {
            return this.m_5953_(mouseX, mouseY) ? 0xD6D6FF : 0xFFFFFF;
        }
        return this.m_5953_(mouseX, mouseY) ? 15916882 : 16772192;
    }

    public static int totalHeightRange(int buttonCount, float scale) {
        return (int)(100.0f / scale + (float)buttonCount * (60.0f / scale));
    }
}

