/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.event.hook;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherMusicManager;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.registries.ForgeRegistries;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.client.audio.ReduxMusicManager;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.mixin.client.audio.MusicManagerAccessor;
import net.zepalesque.redux.mixin.client.audio.SoundEngineAccessor;

public class ReduxAudioHooks {
    public static boolean shouldCancelMusic(SoundEngine soundEngine, SoundInstance sound) {
        if (ReduxAudioHooks.shouldCancel(soundEngine, sound)) {
            return true;
        }
        if (sound.m_8070_() == SoundSource.MUSIC && ((Boolean)ReduxConfig.CLIENT.night_track_music_manager.get()).booleanValue()) {
            return ReduxMusicManager.getSituationalMusic() != null && !sound.m_7904_().equals((Object)SimpleSoundInstance.m_119745_((SoundEvent)ReduxMusicManager.getSituationalMusic().m_11631_()).m_7904_()) && ReduxMusicManager.getSituationalOppositeDaytimeMusic() != null && !sound.m_7904_().equals((Object)SimpleSoundInstance.m_119745_((SoundEvent)ReduxMusicManager.getSituationalOppositeDaytimeMusic().m_11631_()).m_7904_()) || ReduxMusicManager.getCurrentMusic() != null && !sound.m_7904_().equals((Object)ReduxMusicManager.getCurrentMusic().m_7904_());
        }
        return false;
    }

    public static boolean shouldCancel(SoundEngine engine, SoundInstance instance) {
        if (instance.m_8070_() != SoundSource.MUSIC) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        Optional optional = ForgeRegistries.SOUND_EVENTS.getHolder(instance.m_7904_());
        if (optional.isPresent()) {
            Holder sound = (Holder)optional.get();
            if (sound.m_203656_(ReduxTags.Sounds.ALWAYS_ALLOW)) {
                return false;
            }
            Holder biome = mc.f_91074_.f_19853_.m_204166_(mc.f_91074_.m_20183_());
            if (!biome.m_203656_(AetherTags.Biomes.AETHER_MUSIC) && mc.f_91074_.f_19853_.m_46472_() != AetherDimensions.AETHER_LEVEL) {
                return false;
            }
            if (!sound.m_203656_(ReduxTags.Sounds.AETHER_MUSIC)) {
                Redux.LOGGER.info("Caught music track that seems to not belong in the Aether trying to play! Sound ID: {}", (Object)instance.m_7904_());
                return true;
            }
            if (((SoundEngineAccessor)engine).redux$getInstanceToChannel().keySet().stream().anyMatch(tested -> tested == instance)) {
                return false;
            }
            if (ReduxAudioHooks.isCurrentTrack(instance)) {
                return false;
            }
        }
        Redux.LOGGER.info("Caught potential overlapping music track attempting to play in the Aether! Sound ID: {}", (Object)instance.m_7904_());
        Redux.LOGGER.info("If this was logged halfway through the music track playing and cancelled it, this is an issue, please report it to the Aether: Redux's issue tracker.");
        return true;
    }

    private static boolean isCurrentTrack(SoundInstance instance) {
        if (!((Boolean)AetherConfig.CLIENT.disable_music_manager.get()).booleanValue()) {
            return instance == AetherMusicManager.getCurrentMusic();
        }
        if (((Boolean)ReduxConfig.CLIENT.night_track_music_manager.get()).booleanValue()) {
            return instance == ReduxMusicManager.getCurrentMusic();
        }
        return instance == ((MusicManagerAccessor)Minecraft.m_91087_().m_91397_()).redux$getCurrentMusic();
    }

    public static boolean shouldCancelAercloudSound(SoundInstance sound) {
        if (sound.m_8070_() == SoundSource.BLOCKS && !((Boolean)ReduxConfig.CLIENT.aercloud_sfx.get()).booleanValue()) {
            return sound.m_7904_().equals((Object)((SoundEvent)ReduxSoundEvents.BLUE_AERCLOUD_BOUNCE.get()).m_11660_()) || sound.m_7904_().equals((Object)((SoundEvent)ReduxSoundEvents.GOLD_AERCLOUD_WHOOSH.get()).m_11660_());
        }
        return false;
    }

    public static boolean shouldReplacePortalHum(SoundInstance sound) {
        if (sound.m_8070_() == SoundSource.BLOCKS && ((Boolean)ReduxConfig.CLIENT.aether_ii_portal_sounds.get()).booleanValue()) {
            return sound.m_7904_().equals((Object)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_AMBIENT.get()).m_11660_());
        }
        return false;
    }

    public static boolean shouldReplacePortalTrigger(SoundInstance sound) {
        if (sound.m_8070_() == SoundSource.AMBIENT && ((Boolean)ReduxConfig.CLIENT.aether_ii_portal_sounds.get()).booleanValue()) {
            return sound.m_7904_().equals((Object)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRIGGER.get()).m_11660_());
        }
        return false;
    }

    public static boolean shouldReplacePortalTravel(SoundInstance sound) {
        if (sound.m_8070_() == SoundSource.AMBIENT && ((Boolean)ReduxConfig.CLIENT.aether_ii_portal_sounds.get()).booleanValue()) {
            return sound.m_7904_().equals((Object)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRAVEL.get()).m_11660_());
        }
        return false;
    }

    public static boolean shouldCancelPortalSound(SoundEngine soundEngine, SoundInstance sound) {
        if (sound != null && ((Boolean)ReduxConfig.CLIENT.aether_ii_portal_sounds.get()).booleanValue() && sound.m_8070_() == SoundSource.BLOCKS && sound.m_7904_().equals((Object)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_AMBIENT.get()).m_11660_())) {
            List<ResourceLocation> activeSounds = ((SoundEngineAccessor)soundEngine).redux$getInstanceToChannel().keySet().stream().map(SoundInstance::m_7904_).toList();
            return activeSounds.contains(((SoundEvent)ReduxSoundEvents.PORTAL_HUM.get()).m_11660_()) || activeSounds.contains(((SoundEvent)ReduxSoundEvents.PORTAL_TRAVEL.get()).m_11660_()) || activeSounds.contains(((SoundEvent)ReduxSoundEvents.PORTAL_TRIGGER.get()).m_11660_());
        }
        return false;
    }

    public static void tick() {
        if (!Minecraft.m_91087_().m_91104_() && ((Boolean)ReduxConfig.CLIENT.night_track_music_manager.get()).booleanValue()) {
            ReduxMusicManager.tick();
        }
    }

    public static void stop() {
        ReduxMusicManager.stopPlaying();
    }
}

