/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.serialization.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.zepalesque.redux.api.packconfig.PackConfig;
import net.zepalesque.redux.api.serialization.Mapper;
import net.zepalesque.redux.client.gui.component.config.SaveableEditBox;
import net.zepalesque.redux.client.gui.component.config.SaveableEnumButton;
import net.zepalesque.redux.client.gui.screen.config.PackConfigMenu;
import net.zepalesque.redux.util.function.OctoFunction;

@OnlyIn(value=Dist.CLIENT)
public interface WidgetMapper<T>
extends Mapper<T> {
    public static <A extends Enum<A>> WidgetMapper<A> fromEnum(final Class<A> clazz) {
        return new WidgetMapper<A>(){

            @Override
            public Optional<A> decode(JsonElement json) {
                try {
                    return json.isJsonPrimitive() ? Optional.of(Enum.valueOf(clazz, json.getAsString())) : Optional.empty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }

            @Override
            public JsonElement encode(A a) {
                return new JsonPrimitive(((Enum)a).name());
            }

            @Override
            public Optional<A> read(String s) {
                try {
                    return Optional.of(Enum.valueOf(clazz, s));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }

            @Override
            public String write(A a) {
                return ((Enum)a).name();
            }

            @Override
            public AbstractWidget createWidget(PackConfig<?> config, int pg, PackConfigMenu screen, int x, int y, int width, int height, Font font) {
                return new SaveableEnumButton(x, y, width, height, config, pg, screen);
            }
        };
    }

    default public AbstractWidget createWidget(PackConfig<?> config, int pg, PackConfigMenu screen, int x, int y, int width, int height, Font font) {
        return new SaveableEditBox(font, x, y, width, height, config, pg, screen);
    }

    default public <Q> WidgetMapper<Q> xmap(Function<T, Q> to, final Function<Q, T> from, final OctoFunction<PackConfig<?>, Integer, PackConfigMenu, Integer, Integer, Integer, Integer, Font, AbstractWidget> widgetConstructor) {
        final Function<Optional, Optional> optionalFunc = ogVal -> ogVal.isEmpty() ? Optional.empty() : Optional.of(to.apply(ogVal.get()));
        final WidgetMapper og = this;
        return new WidgetMapper<Q>(){

            @Override
            public Optional<Q> decode(JsonElement json) {
                return (Optional)optionalFunc.apply(og.decode(json));
            }

            @Override
            public JsonElement encode(Q q) {
                return og.encode(from.apply(q));
            }

            @Override
            public Optional<Q> read(String s) {
                return (Optional)optionalFunc.apply(og.read(s));
            }

            @Override
            public String write(Q q) {
                return og.write(from.apply(q));
            }

            @Override
            public AbstractWidget createWidget(PackConfig<?> config, int pg, PackConfigMenu screen, int x, int y, int width, int height, Font font) {
                return (AbstractWidget)widgetConstructor.apply(config, pg, screen, x, y, width, height, font);
            }
        };
    }

    public static <T> WidgetMapper<T> fromMapper(final Mapper<T> mapper) {
        return new WidgetMapper<T>(){

            @Override
            public Optional<T> decode(JsonElement data) {
                return mapper.decode(data);
            }

            @Override
            public JsonElement encode(T value) {
                return mapper.encode(value);
            }

            @Override
            public Optional<T> read(String data) {
                return mapper.read(data);
            }

            @Override
            public String write(T value) {
                return mapper.write(value);
            }
        };
    }

    public static <T> WidgetMapper<T> fromMapper(final Mapper<T> mapper, final OctoFunction<PackConfig<?>, Integer, PackConfigMenu, Integer, Integer, Integer, Integer, Font, AbstractWidget> widgetConstructor) {
        return new WidgetMapper<T>(){

            @Override
            public Optional<T> decode(JsonElement data) {
                return mapper.decode(data);
            }

            @Override
            public JsonElement encode(T value) {
                return mapper.encode(value);
            }

            @Override
            public Optional<T> read(String data) {
                return mapper.read(data);
            }

            @Override
            public String write(T value) {
                return mapper.write(value);
            }

            @Override
            public AbstractWidget createWidget(PackConfig<?> config, int pg, PackConfigMenu screen, int x, int y, int width, int height, Font font) {
                return (AbstractWidget)widgetConstructor.apply(config, pg, screen, x, y, width, height, font);
            }
        };
    }
}

