/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.function.Function;
import net.zepalesque.redux.api.serialization.Mapper;

public class Mappers {
    public static final Mapper<String> STRING = new Mapper<String>(){

        @Override
        public Optional<String> decode(JsonElement json) {
            return Mappers.primitiveOptional(json, JsonElement::getAsString);
        }

        @Override
        public JsonElement encode(String s) {
            return new JsonPrimitive(s);
        }

        @Override
        public Optional<String> read(String s) {
            return Optional.of(s);
        }

        @Override
        public String write(String s) {
            return s;
        }
    };
    public static final Mapper<Integer> INT = new Mapper<Integer>(){

        @Override
        public Optional<Integer> decode(JsonElement data) {
            return Mappers.primitiveOptional(data, JsonElement::getAsInt);
        }

        @Override
        public JsonElement encode(Integer value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Optional<Integer> read(String data) {
            return Mappers.emptyIfError(data, Integer::valueOf);
        }

        @Override
        public String write(Integer value) {
            return value.toString();
        }
    };
    public static final Mapper<Long> LONG = new Mapper<Long>(){

        @Override
        public Optional<Long> decode(JsonElement data) {
            return Mappers.primitiveOptional(data, JsonElement::getAsLong);
        }

        @Override
        public JsonElement encode(Long value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Optional<Long> read(String data) {
            return Mappers.emptyIfError(data, Long::valueOf);
        }

        @Override
        public String write(Long value) {
            return value.toString();
        }
    };
    public static final Mapper<Float> FLOAT = new Mapper<Float>(){

        @Override
        public Optional<Float> decode(JsonElement data) {
            return Mappers.primitiveOptional(data, JsonElement::getAsFloat);
        }

        @Override
        public JsonElement encode(Float value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Optional<Float> read(String data) {
            return Mappers.emptyIfError(data, Float::valueOf);
        }

        @Override
        public String write(Float value) {
            return value.toString();
        }
    };
    public static final Mapper<Double> DOUBLE = new Mapper<Double>(){

        @Override
        public Optional<Double> decode(JsonElement data) {
            return Mappers.primitiveOptional(data, JsonElement::getAsDouble);
        }

        @Override
        public JsonElement encode(Double value) {
            return new JsonPrimitive((Number)value);
        }

        @Override
        public Optional<Double> read(String data) {
            return Mappers.emptyIfError(data, Double::valueOf);
        }

        @Override
        public String write(Double value) {
            return value.toString();
        }
    };
    public static final Mapper<Boolean> BOOL = new Mapper<Boolean>(){

        @Override
        public Optional<Boolean> decode(JsonElement data) {
            return Mappers.primitiveOptional(data, JsonElement::getAsBoolean);
        }

        @Override
        public JsonElement encode(Boolean value) {
            return new JsonPrimitive(value);
        }

        @Override
        public Optional<Boolean> read(String data) {
            return Mappers.emptyIfError(data, Boolean::valueOf);
        }

        @Override
        public String write(Boolean value) {
            return value.toString();
        }
    };

    public static <T> Optional<T> primitiveOptional(JsonElement json, Function<JsonElement, T> method) {
        try {
            return json.isJsonPrimitive() ? Optional.of(method.apply(json)) : Optional.empty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static <T> Optional<T> emptyIfError(String data, Function<String, T> func) {
        try {
            T value = func.apply(data);
            return Optional.of(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

