/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.mixin.mixins.common.accessor.SpreadingSnowyDirtBlockAccessor;
import com.aetherteam.aether.world.processor.DoubleDropsProcessor;
import com.aetherteam.aether.world.processor.GlowstonePortalAgeProcessor;
import com.aetherteam.aether.world.processor.HolystoneReplaceProcessor;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class GlowstoneRuinedPortalPiece
extends TemplateStructurePiece {
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public GlowstoneRuinedPortalPiece(StructureTemplateManager structureTemplateManager, BlockPos templatePosition, VerticalPlacement verticalPlacement, Properties properties, ResourceLocation location, Rotation rotation, Mirror mirror, BlockPos pivotPos) {
        super((StructurePieceType)AetherStructurePieceTypes.RUINED_PORTAL.get(), 0, structureTemplateManager, location, location.toString(), GlowstoneRuinedPortalPiece.makeSettings(mirror, rotation, pivotPos, properties), templatePosition);
        this.verticalPlacement = verticalPlacement;
        this.properties = properties;
    }

    public GlowstoneRuinedPortalPiece(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
        super((StructurePieceType)AetherStructurePieceTypes.RUINED_PORTAL.get(), tag, structureTemplateManager, location -> GlowstoneRuinedPortalPiece.makeSettings(structureTemplateManager, tag, location));
        this.verticalPlacement = VerticalPlacement.byName(tag.m_128461_("VerticalPlacement"));
        this.properties = (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("Properties"))).getOrThrow(true, arg_0 -> ((Logger)Aether.LOGGER).error(arg_0));
    }

    public GlowstoneRuinedPortalPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
        tag.m_128359_("Mirror", this.f_73657_.m_74401_().name());
        tag.m_128359_("VerticalPlacement", this.verticalPlacement.getName());
        Properties.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.properties).resultOrPartial(arg_0 -> ((Logger)Aether.LOGGER).error(arg_0)).ifPresent(propertiesTag -> tag.m_128365_("Properties", propertiesTag));
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager structureTemplateManager, CompoundTag tag, ResourceLocation location) {
        StructureTemplate structuretemplate = structureTemplateManager.m_230359_(location);
        BlockPos blockpos = new BlockPos(structuretemplate.m_163801_().m_123341_() / 2, 0, structuretemplate.m_163801_().m_123343_() / 2);
        return GlowstoneRuinedPortalPiece.makeSettings(Mirror.valueOf((String)tag.m_128461_("Mirror")), Rotation.valueOf((String)tag.m_128461_("Rotation")), blockpos, (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("Properties"))).getOrThrow(true, arg_0 -> ((Logger)Aether.LOGGER).error(arg_0)));
    }

    private static StructurePlaceSettings makeSettings(Mirror mirror, Rotation rotation, BlockPos pos, Properties properties) {
        BlockIgnoreProcessor blockIgnoreProcessor = properties.airPocket ? BlockIgnoreProcessor.f_74046_ : BlockIgnoreProcessor.f_74048_;
        ArrayList list = Lists.newArrayList();
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror).m_74385_(pos).m_74383_((StructureProcessor)blockIgnoreProcessor).m_74383_((StructureProcessor)new RuleProcessor((List)list)).m_74383_((StructureProcessor)new GlowstonePortalAgeProcessor(properties.mossiness)).m_74383_((StructureProcessor)new DoubleDropsProcessor()).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_));
        if (properties.replaceWithHolystone) {
            structurePlaceSettings.m_74383_((StructureProcessor)HolystoneReplaceProcessor.INSTANCE);
        }
        return structurePlaceSettings;
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        BoundingBox boundingbox = this.f_73656_.m_74633_(this.f_73657_, this.f_73658_);
        if (box.m_71051_((Vec3i)boundingbox.m_162394_())) {
            box.m_162386_(boundingbox);
            super.m_213694_(level, structureManager, generator, random, box, chunkPos, pos);
            this.spreadAetherGrass(random, (LevelAccessor)level);
            this.addDirtBuryingBelowPortal(random, (LevelAccessor)level);
            if (this.properties.vines || this.properties.overgrown) {
                BlockPos.m_121919_((BoundingBox)this.m_73547_()).forEach(p_229127_ -> {
                    if (this.properties.vines) {
                        this.maybeAddVines(random, (LevelAccessor)level, (BlockPos)p_229127_);
                    }
                    if (this.properties.overgrown) {
                        this.maybeAddLeavesAbove(random, (LevelAccessor)level, (BlockPos)p_229127_);
                    }
                });
            }
        }
    }

    protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
    }

    private void maybeAddVines(RandomSource random, LevelAccessor level, BlockPos pos) {
        Direction direction;
        BlockPos blockPos;
        BlockState relativeState;
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50191_) && (relativeState = level.m_8055_(blockPos = pos.m_121945_(direction = GlowstoneRuinedPortalPiece.m_226760_((RandomSource)random)))).m_60795_() && Block.m_49918_((VoxelShape)blockState.m_60812_((BlockGetter)level, pos), (Direction)direction)) {
            BooleanProperty property = VineBlock.m_57883_((Direction)direction.m_122424_());
            level.m_7731_(blockPos, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)property, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void maybeAddLeavesAbove(RandomSource random, LevelAccessor level, BlockPos pos) {
        if (random.m_188501_() < 0.5f && level.m_8055_(pos).m_60713_((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos.m_7494_(), (BlockState)Blocks.f_50053_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void addDirtBuryingBelowPortal(RandomSource random, LevelAccessor level) {
        for (int i = this.f_73383_.m_162395_() + 1; i < this.f_73383_.m_162399_(); ++i) {
            for (int j = this.f_73383_.m_162398_() + 1; j < this.f_73383_.m_162401_(); ++j) {
                BlockPos blockPos = new BlockPos(i, this.f_73383_.m_162396_(), j);
                if (!level.m_8055_(blockPos).m_60713_((Block)AetherBlocks.AETHER_GRASS_BLOCK.get())) continue;
                this.addDirtBuryingColumn(random, level, blockPos.m_7495_());
            }
        }
    }

    private void addDirtBuryingColumn(RandomSource random, LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
        this.placeAetherDirtOrGrass(random, level, (BlockPos)mutableBlockPos);
        for (int i = 8; i > 0 && random.m_188501_() < 0.5f; --i) {
            mutableBlockPos.m_122173_(Direction.DOWN);
            this.placeAetherDirtOrGrass(random, level, (BlockPos)mutableBlockPos);
        }
    }

    private void spreadAetherGrass(RandomSource random, LevelAccessor level) {
        boolean flag = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos blockPos = this.f_73383_.m_162394_();
        int i = blockPos.m_123341_();
        int j = blockPos.m_123343_();
        float[] afloat = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k = afloat.length;
        int l = (this.f_73383_.m_71056_() + this.f_73383_.m_71058_()) / 2;
        int i1 = random.m_188503_(Math.max(1, 8 - l / 2));
        BlockPos.MutableBlockPos mutablePos = BlockPos.f_121853_.m_122032_();
        for (int k1 = i - k; k1 <= i + k; ++k1) {
            for (int l1 = j - k; l1 <= j + k; ++l1) {
                int i2 = Math.abs(k1 - i) + Math.abs(l1 - j);
                int j2 = Math.max(0, i2 + i1);
                if (j2 >= k) continue;
                float f = afloat[j2];
                if (!(random.m_188500_() < (double)f)) continue;
                int k2 = GlowstoneRuinedPortalPiece.getSurfaceY(level, k1, l1, this.verticalPlacement);
                int l2 = flag ? k2 : Math.min(this.f_73383_.m_162396_(), k2);
                mutablePos.m_122178_(k1, l2, l1);
                if (Math.abs(l2 - this.f_73383_.m_162396_()) > 3 || !this.canBlockBeReplacedByAetherGrass(level, (BlockPos)mutablePos)) continue;
                this.placeAetherDirtOrGrass(random, level, (BlockPos)mutablePos);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(random, level, (BlockPos)mutablePos);
                }
                this.addDirtBuryingColumn(random, level, mutablePos.m_7495_());
            }
        }
    }

    private boolean canBlockBeReplacedByAetherGrass(LevelAccessor level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_204336_(AetherTags.Blocks.RUINED_PORTAL_GROUND_REPLACEABLE);
    }

    private void placeAetherDirtOrGrass(RandomSource random, LevelAccessor level, BlockPos pos) {
        if (SpreadingSnowyDirtBlockAccessor.callCanBeGrass(((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).m_49966_(), (LevelReader)level, pos)) {
            level.m_7731_(pos, (BlockState)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)), 3);
            this.growGrassAndFlowers(random, level, pos.m_7494_());
        } else {
            level.m_7731_(pos, (BlockState)((Block)AetherBlocks.AETHER_DIRT.get()).m_49966_().m_61124_((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void growGrassAndFlowers(RandomSource random, LevelAccessor level, BlockPos pos) {
        int featureType = random.m_188503_(50);
        if (random.m_188503_(100) < 20 && level.m_46859_(pos)) {
            if (featureType < 5 && level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.AETHER_DIRT)) {
                Block flower = random.m_188499_() ? (Block)AetherBlocks.PURPLE_FLOWER.get() : (Block)AetherBlocks.WHITE_FLOWER.get();
                level.m_7731_(pos, flower.m_49966_(), 2);
            } else if (random.m_188503_(50) > 5) {
                level.m_7731_(pos, Blocks.f_50034_.m_49966_(), 2);
            } else {
                DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)Blocks.f_50359_.m_49966_(), (BlockPos)pos, (int)2);
            }
        }
    }

    private static int getSurfaceY(LevelAccessor level, int x, int z, VerticalPlacement verticalPlacement) {
        return level.m_6924_(GlowstoneRuinedPortalPiece.getHeightMapType(verticalPlacement), x, z) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement verticalPlacement) {
        return verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR : Heightmap.Types.WORLD_SURFACE;
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(properties -> properties.replaceWithHolystone)).apply((Applicative)codec, Properties::new));
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithHolystone;

        public Properties() {
        }

        public Properties(float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithHolystone) {
            this.mossiness = mossiness;
            this.airPocket = airPocket;
            this.overgrown = overgrown;
            this.vines = vines;
            this.replaceWithHolystone = replaceWithHolystone;
        }
    }

    public static enum VerticalPlacement implements StringRepresentable
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor");

        public static final StringRepresentable.EnumCodec<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static VerticalPlacement byName(String name) {
            return (VerticalPlacement)CODEC.m_216455_(name);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(VerticalPlacement::values);
        }
    }
}

