/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.ban;

import com.aetherteam.aether.integration.jei.categories.BiomeTooltip;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.nitrogen.integration.jei.BlockStateRenderer;
import com.aetherteam.nitrogen.integration.jei.FluidStateRenderer;
import com.aetherteam.nitrogen.integration.jei.categories.AbstractRecipeCategory;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractPlacementBanRecipeCategory<T, S extends Predicate<T>, R extends AbstractPlacementBanRecipe<T, S>>
extends AbstractRecipeCategory<R>
implements BiomeTooltip {
    protected final IPlatformFluidHelper<?> fluidHelper;
    private final IDrawable slot;

    public AbstractPlacementBanRecipeCategory(IGuiHelper guiHelper, String id, ResourceLocation uid, IDrawable background, IDrawable icon, RecipeType<R> recipeType, IPlatformFluidHelper<?> fluidHelper) {
        super(id, uid, background, icon, recipeType);
        this.fluidHelper = fluidHelper;
        this.slot = guiHelper.getSlotDrawable();
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.aether.jei." + this.id));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focusGroup) {
        BlockStateIngredient bypassBlockIngredient = ((AbstractPlacementBanRecipe)recipe).getBypassBlock();
        BlockPropertyPair[] pairs = bypassBlockIngredient.getPairs();
        if (pairs != null) {
            List<Object> ingredients = this.setupIngredients(pairs);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 99, 1).addIngredientsUnsafe(ingredients)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), (IIngredientRenderer)new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
        }
    }

    protected List<Object> setupIngredients(BlockPropertyPair[] pairs) {
        ArrayList<Object> ingredients = new ArrayList<Object>();
        if (Minecraft.m_91087_().f_91073_ != null) {
            for (BlockPropertyPair pair : pairs) {
                Block block = pair.block();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)block;
                    ingredients.add(this.fluidHelper.create((Fluid)liquidBlock.getFluid(), 1000L));
                    continue;
                }
                BlockState state = pair.block().m_49966_();
                for (Map.Entry propertyEntry : pair.properties().entrySet()) {
                    state = BlockStateRecipeUtil.setHelper(propertyEntry, (BlockState)state);
                }
                ItemStack stack = pair.block().m_7397_((BlockGetter)Minecraft.m_91087_().f_91073_, BlockPos.f_121853_, state);
                stack = stack.m_41619_() ? new ItemStack((ItemLike)Blocks.f_50069_) : stack;
                ingredients.add(stack);
            }
        }
        return ingredients;
    }

    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        if (((AbstractPlacementBanRecipe)recipe).getBypassBlock() == null || ((AbstractPlacementBanRecipe)recipe).getBypassBlock().isEmpty()) {
            this.slot.draw(poseStack, 49, 0);
        } else {
            this.slot.draw(poseStack);
            this.slot.draw(poseStack, 98, 0);
            String text = Translator.translateToLocalFormatted((String)"gui.aether.jei.bypass", (Object[])new Object[0]);
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92883_(poseStack, text, 24.0f, 5.0f, -8355712);
        }
    }

    protected void populateAdditionalInformation(R recipe, List<Component> tooltip) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.populateBiomeInformation(((AbstractPlacementBanRecipe)recipe).getBiomeKey(), ((AbstractPlacementBanRecipe)recipe).getBiomeTag(), tooltip);
        }
    }
}

