/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public abstract class WingedAnimal
extends MountableAnimal {
    private float wingFold;
    private float wingAngle;

    public WingedAnimal(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FallPathNavigation((Mob)this, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, -0.1);
            if (this.m_20184_().m_7098_() < fallSpeed && !this.playerTriedToCrouch()) {
                this.m_20334_(this.m_20184_().m_7096_(), fallSpeed, this.m_20184_().m_7094_());
                this.f_19812_ = true;
                this.setEntityOnGround(false);
            }
        }
    }

    @Override
    public void riderTick() {
        super.riderTick();
        if (this.getControllingPassenger() instanceof Player) {
            EntityUtil.checkSlowFallDistance((Entity)this);
        }
    }

    public float getWingFold() {
        return this.wingFold;
    }

    public void setWingFold(float wingFold) {
        this.wingFold = wingFold;
    }

    public float getWingAngle() {
        return this.wingAngle;
    }

    public void setWingAngle(float wingAngle) {
        this.wingAngle = wingAngle;
    }

    @Override
    public float getFlyingSpeed() {
        if (this.m_6142_() && !this.m_20096_() && this.m_20197_().isEmpty()) {
            return this.m_6113_() * (0.24f / (float)Math.pow(0.91f, 3.0));
        }
        return super.getFlyingSpeed();
    }

    @Override
    public boolean canJump() {
        return this.m_6254_();
    }

    public int m_6056_() {
        return this.m_20096_() ? super.m_6056_() : 14;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }
}

