/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class Aerwhale
extends FlyingMob {
    private static final EntityDataAccessor<Float> DATA_X_ROT_O_ID = SynchedEntityData.m_135353_(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_X_ROT_ID = SynchedEntityData.m_135353_(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_Y_ROT_ID = SynchedEntityData.m_135353_(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Aerwhale(EntityType<? extends Aerwhale> type, Level level) {
        super(type, level);
        this.f_21365_ = new BlankLookControl((Mob)this);
        this.f_21342_ = new AerwhaleMoveControl(this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SetTravelCourseGoal((Mob)this));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, 0.2).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.4);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_X_ROT_O_ID, (Object)Float.valueOf(this.m_146909_()));
        this.m_20088_().m_135372_(DATA_X_ROT_ID, (Object)Float.valueOf(this.m_146909_()));
        this.m_20088_().m_135372_(DATA_Y_ROT_ID, (Object)Float.valueOf(this.m_146908_()));
    }

    public static boolean checkAerwhaleSpawnRules(EntityType<? extends Aerwhale> aerwhale, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(aerwhale, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && level.m_6425_(pos).m_192917_(Fluids.f_76191_) && level.m_45524_(pos, 0) > 8 && level.m_45527_(pos) && (reason != MobSpawnType.NATURAL || random.m_188503_(40) == 0);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_146926_(this.getXRotData());
        this.m_146922_(this.getYRotData());
        this.m_5618_(this.getYRotData());
        this.m_5616_(this.getYRotData());
    }

    public void m_7023_(Vec3 vector) {
        if (this.m_6142_() || this.m_6109_()) {
            List passengers = this.m_20197_();
            if (!passengers.isEmpty()) {
                Entity entity = (Entity)passengers.get(0);
                if (entity instanceof Player) {
                    double d1;
                    double d0;
                    Player player = (Player)entity;
                    this.m_146922_(player.m_146908_() + 90.0f);
                    this.f_19859_ = this.m_146908_();
                    this.m_146926_(-player.m_146909_());
                    this.f_19860_ = this.m_146909_() * 0.5f;
                    this.m_5616_(player.f_20885_);
                    vector = new Vec3((double)player.f_20900_, 0.0, player.f_20902_ <= 0.0f ? (double)(player.f_20902_ * 0.25f) : (double)player.f_20902_);
                    if (AetherPlayer.get(player).map(AetherPlayer::isJumping).orElse(false).booleanValue()) {
                        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                    } else {
                        d0 = Math.toRadians(this.m_146908_());
                        d1 = Math.toRadians(-player.m_146909_());
                        double d2 = Math.cos(d1);
                        this.m_20334_(0.98 * (this.m_20184_().m_7096_() + 0.05 * Math.cos(d0) * d2), 0.98 * (this.m_20184_().m_7098_() + 0.02 * Math.sin(d1)), 0.98 * (this.m_20184_().m_7094_() + 0.05 * Math.sin(d0) * d2));
                    }
                    if (!this.m_9236_().m_5776_()) {
                        this.f_20887_ = this.m_6113_() * 0.6f;
                        super.m_7023_(vector);
                    }
                    this.f_20923_ = this.f_20924_;
                    d0 = this.m_20185_() - this.f_19854_;
                    float f4 = 4.0f * Mth.m_14116_((float)((float)(d0 * d0 + (d1 = this.m_20189_() - this.f_19856_) * d1)));
                    if (f4 > 1.0f) {
                        f4 = 1.0f;
                    }
                    this.f_20924_ += 0.4f * (f4 - this.f_20924_);
                    this.f_20925_ += this.f_20924_;
                }
            } else {
                super.m_7023_(vector);
            }
        }
    }

    public void m_8119_() {
        this.setXRotOData(this.getXRotData());
        super.m_8119_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_20148_().equals(UUID.fromString("031025bd-0a15-439b-9c55-06a20d0de76f"))) {
            player.m_20329_((Entity)this);
            if (!this.m_9236_().m_5776_()) {
                MutableComponent msg = Component.m_237113_((String)"Serenity is the queen of W(h)ales!!");
                player.m_9236_().m_6907_().forEach(p -> p.m_213846_((Component)msg));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public float getXRotOData() {
        return ((Float)this.m_20088_().m_135370_(DATA_X_ROT_O_ID)).floatValue();
    }

    public void setXRotOData(float rot) {
        this.m_20088_().m_135381_(DATA_X_ROT_O_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getXRotData() {
        return ((Float)this.m_20088_().m_135370_(DATA_X_ROT_ID)).floatValue();
    }

    public void setXRotData(float rot) {
        this.m_20088_().m_135381_(DATA_X_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    public float getYRotData() {
        return ((Float)this.m_20088_().m_135370_(DATA_Y_ROT_ID)).floatValue();
    }

    public void setYRotData(float rot) {
        this.m_20088_().m_135381_(DATA_Y_ROT_ID, (Object)Float.valueOf(Mth.m_14177_((float)rot)));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_DEATH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERWHALE_DEATH.get();
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int m_213860_() {
        return 1 + this.m_9236_().m_213780_().m_188503_(3);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(3.0);
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return true;
    }

    protected double followLeashSpeed() {
        return 1.0;
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_6060_() {
        return false;
    }

    public static class BlankLookControl
    extends LookControl {
        public BlankLookControl(Mob pMob) {
            super(pMob);
        }

        public void m_8128_() {
        }
    }

    public static class AerwhaleMoveControl
    extends MoveControl {
        protected final Aerwhale mob;

        public AerwhaleMoveControl(Aerwhale pMob) {
            super((Mob)pMob);
            this.mob = pMob;
        }

        public void m_8126_() {
            if (this.mob.m_20160_()) {
                return;
            }
            double x = this.m_25000_() - this.mob.m_20185_();
            double y = this.m_25001_() - this.mob.m_20186_();
            double z = this.m_25002_() - this.mob.m_20189_();
            double distance = Math.sqrt(x * x + z * z);
            if (distance < 3.0 || this.isColliding(new Vec3(x, y, z).m_82541_())) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
            float xRotTarget = (float)(Mth.m_14136_((double)y, (double)distance) * 57.2957763671875);
            float xRot = Mth.m_14177_((float)this.mob.m_146909_());
            xRot = Mth.m_14148_((float)xRot, (float)xRotTarget, (float)0.2f);
            this.mob.m_146926_(xRot);
            this.mob.setXRotData(this.mob.m_146909_());
            float yRotTarget = Mth.m_14177_((float)((float)Mth.m_14136_((double)z, (double)x) * 57.295776f));
            float yRot = Mth.m_14177_((float)(this.mob.m_146908_() + 90.0f));
            yRot = Mth.m_14148_((float)yRot, (float)yRotTarget, (float)0.5f);
            this.mob.m_146922_(yRot - 90.0f);
            this.mob.setYRotData(this.mob.m_146908_());
            this.mob.m_5618_(yRot);
            this.mob.m_5616_(yRot);
            x = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
            y = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(xRot * ((float)Math.PI / 180)));
            z = this.mob.m_21133_(Attributes.f_22280_) * (double)Mth.m_14031_((float)(yRot * ((float)Math.PI / 180)));
            Vec3 motion = new Vec3(x, y, z);
            this.mob.m_20256_(motion);
            Entity entity = this.mob.m_21524_();
            if (entity != null && entity.m_9236_() == this.mob.m_9236_()) {
                this.mob.m_21446_(entity.m_20183_(), 5);
                float f = this.mob.m_20270_(entity);
                if (f > 10.0f) {
                    this.mob.m_21455_(true, true);
                    this.mob.f_21345_.m_25355_(Goal.Flag.MOVE);
                } else if (f > 6.0f) {
                    double d0 = (entity.m_20185_() - this.mob.m_20185_()) / (double)f;
                    double d1 = (entity.m_20186_() - this.mob.m_20186_()) / (double)f;
                    double d2 = (entity.m_20189_() - this.mob.m_20189_()) / (double)f;
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
                    EntityUtil.checkSlowFallDistance((Entity)this.mob);
                } else if (this.mob.shouldStayCloseToLeashHolder()) {
                    this.mob.f_21345_.m_25374_(Goal.Flag.MOVE);
                    Vec3 vec3 = new Vec3(entity.m_20185_() - this.mob.m_20185_(), entity.m_20186_() - this.mob.m_20186_(), entity.m_20189_() - this.mob.m_20189_()).m_82541_().m_82490_((double)Math.max(f - 2.0f, 0.0f));
                    this.mob.m_21573_().m_26519_(this.mob.m_20185_() + vec3.f_82479_, this.mob.m_20186_() + vec3.f_82480_, this.mob.m_20189_() + vec3.f_82481_, this.mob.followLeashSpeed());
                }
            }
        }

        private boolean isColliding(Vec3 pos) {
            AABB axisalignedbb = this.mob.m_20191_();
            for (int i = 1; i < 7; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(pos);
                if (this.mob.m_9236_().m_45756_((Entity)this.mob, axisalignedbb)) continue;
                return true;
            }
            return false;
        }
    }

    public static class SetTravelCourseGoal
    extends Goal {
        private final Mob mob;

        public SetTravelCourseGoal(Mob mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.mob.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.mob.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.mob.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.mob.m_20189_()) * d2;
            return d3 < 1.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.mob.m_217043_();
            double x = (random.m_188501_() * 2.0f - 1.0f) * 16.0f;
            double z = (random.m_188501_() * 2.0f - 1.0f) * 16.0f;
            double y = this.mob.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            x = x >= 0.0 ? x + 32.0 : x - 32.0;
            z = z >= 0.0 ? z + 32.0 : z - 32.0;
            y = Mth.m_14008_((double)y, (double)this.mob.m_9236_().m_141937_(), (double)this.mob.m_9236_().m_151558_());
            this.mob.m_21566_().m_6849_(x += this.mob.m_20185_(), y, z += this.mob.m_20189_(), 1.0);
        }
    }
}

