/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.mixin.mixins.client.accessor.GuiAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.HeartTypeAccessor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AetherOverlays {
    private static final ResourceLocation TEXTURE_INEBRIATION_VIGNETTE = new ResourceLocation("aether", "textures/blur/inebriation_vignette.png");
    private static final ResourceLocation TEXTURE_REMEDY_VIGNETTE = new ResourceLocation("aether", "textures/blur/remedy_vignette.png");
    private static final ResourceLocation TEXTURE_SHIELD_OF_REPULSION_VIGNETTE = new ResourceLocation("aether", "textures/blur/shield_of_repulsion_vignette.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = new ResourceLocation("aether", "textures/gui/cooldown_bar.png");
    private static final ResourceLocation TEXTURE_JUMPS = new ResourceLocation("aether", "textures/gui/jumps.png");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_HEARTS = new ResourceLocation("aether", "textures/gui/life_shard_hearts.png");

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("aether_portal_overlay", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderAetherPortalOverlay(pStack, minecraft, window, handler, partialTicks));
            }
        });
        event.registerAboveAll("inebriation_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderInebriationOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("remedy_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderRemedyOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("shield_of_repulsion_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderRepulsionOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("hammer_cooldown", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderHammerCooldownOverlay(pStack, minecraft, window, player);
            }
        });
        event.registerAboveAll("moa_jumps", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderMoaJumps(pStack, window, player);
            }
        });
        event.registerAbove(new ResourceLocation("player_health"), "silver_life_shard_hearts", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderSilverLifeShardHearts(pStack, gui, player, screenWidth, screenHeight);
            }
        });
    }

    private static void renderAetherPortalOverlay(PoseStack poseStack, Minecraft minecraft, Window window, AetherPlayer handler, float partialTicks) {
        float timeInPortal = handler.getPrevPortalAnimTime() + (handler.getPortalAnimTime() - handler.getPrevPortalAnimTime()) * partialTicks;
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)timeInPortal);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            TextureAtlasSprite textureAtlasSprite = minecraft.m_91289_().m_110907_().m_110882_(((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).m_49966_());
            GuiComponent.m_93200_((PoseStack)poseStack, (int)0, (int)0, (int)-90, (int)window.m_85445_(), (int)window.m_85446_(), (TextureAtlasSprite)textureAtlasSprite);
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69482_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
    }

    private static void renderInebriationOverlay(PoseStack poseStack, Minecraft minecraft, Window window, AetherPlayer handler) {
        Player player = handler.getPlayer();
        MobEffectInstance inebriation = player.m_21124_((MobEffect)AetherEffects.INEBRIATION.get());
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (inebriation != null) {
            float inebriationDuration = (float)(inebriation.m_19557_() % 50) / 50.0f;
            float alpha = inebriationDuration * inebriationDuration / 5.0f + 0.4f;
            AetherOverlays.renderVignette(poseStack, window, effectScale, alpha, TEXTURE_INEBRIATION_VIGNETTE);
        }
    }

    private static void renderRemedyOverlay(PoseStack poseStack, Minecraft minecraft, Window window, AetherPlayer handler) {
        Player player = handler.getPlayer();
        MobEffectInstance remedy = player.m_21124_((MobEffect)AetherEffects.REMEDY.get());
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (remedy != null) {
            int remedyStartDuration = handler.getRemedyStartDuration();
            int remedyDuration = remedy.m_19557_();
            if (remedyStartDuration > 0 && remedyDuration > 0) {
                float alpha = (float)remedyDuration / (float)remedyStartDuration / 1.5f;
                AetherOverlays.renderVignette(poseStack, window, effectScale, alpha, TEXTURE_REMEDY_VIGNETTE);
            }
        }
    }

    private static void renderRepulsionOverlay(PoseStack poseStack, Minecraft minecraft, Window window, AetherPlayer handler) {
        int projectileImpactedMaximum = handler.getProjectileImpactedMaximum();
        int projectileImpactedTimer = handler.getProjectileImpactedTimer();
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (projectileImpactedTimer > 0) {
            float alpha = (float)projectileImpactedTimer / (float)projectileImpactedMaximum;
            AetherOverlays.renderVignette(poseStack, window, effectScale, alpha, TEXTURE_SHIELD_OF_REPULSION_VIGNETTE);
        }
    }

    private static void renderVignette(PoseStack poseStack, Window window, double effectScale, float alpha, ResourceLocation resource) {
        poseStack.m_85836_();
        alpha = (float)((double)alpha * Math.sqrt(effectScale));
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resource);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)0, (int)0, (int)-90, (float)0.0f, (float)0.0f, (int)window.m_85445_(), (int)window.m_85446_(), (int)window.m_85445_(), (int)window.m_85446_());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        poseStack.m_85849_();
    }

    private static void renderHammerCooldownOverlay(PoseStack poseStack, Minecraft minecraft, Window window, LocalPlayer player) {
        Inventory inventory;
        if (((Boolean)AetherConfig.CLIENT.enable_hammer_cooldown_overlay.get()).booleanValue() && (inventory = player.m_150109_()).m_216874_(itemStack -> itemStack.m_150930_((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()))) {
            for (ItemStack itemStack2 : inventory.f_35974_) {
                float cooldownPercent;
                Item item = itemStack2.m_41720_();
                if (item != AetherItems.HAMMER_OF_KINGBDOGZ.get() || !((cooldownPercent = player.m_36335_().m_41521_(item, 0.0f)) > 0.0f)) continue;
                if (player.m_21205_().m_41720_() == item) {
                    itemStack2 = player.m_21205_();
                } else if (player.m_21206_().m_41720_() == item) {
                    itemStack2 = player.m_21206_();
                }
                String text = itemStack2.m_41786_().getString().concat(" ").concat(Component.m_237115_((String)"aether.hammer_of_kingbdogz_cooldown").getString());
                minecraft.f_91062_.m_92750_(poseStack, text, (float)window.m_85445_() / 2.0f - (float)minecraft.f_91062_.m_92895_(text) / 2.0f, 32.0f, 0xFFFFFF);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_COOLDOWN_BAR);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(window.m_85445_() / 2 - 64), (int)42, (float)0.0f, (float)8.0f, (int)128, (int)8, (int)256, (int)256);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(window.m_85445_() / 2 - 64), (int)42, (float)0.0f, (float)0.0f, (int)((int)(cooldownPercent * 128.0f)), (int)8, (int)256, (int)256);
                break;
            }
        }
    }

    private static void renderMoaJumps(PoseStack poseStack, Window window, LocalPlayer player) {
        Entity entity = player.m_20202_();
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_JUMPS);
            for (int jumpCount = 0; jumpCount < moa.getMaxJumps(); ++jumpCount) {
                int xPos = window.m_85445_() / 2 + jumpCount * 8 - moa.getMaxJumps() * 8 / 2;
                int yPos = 18;
                if (jumpCount < moa.getRemainingJumps()) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)9, (int)11, (int)256, (int)256);
                    continue;
                }
                GuiComponent.m_93133_((PoseStack)poseStack, (int)xPos, (int)yPos, (float)10.0f, (float)0.0f, (int)9, (int)11, (int)256, (int)256);
            }
        }
    }

    private static void renderSilverLifeShardHearts(PoseStack poseStack, ForgeGui gui, LocalPlayer player, int width, int height) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        if (((Boolean)AetherConfig.CLIENT.enable_silver_hearts.get()).booleanValue() && gui.shouldDrawSurvivalElements()) {
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                AttributeInstance attributeInstance;
                Player innerPlayer = aetherPlayer.getPlayer();
                if (aetherPlayer.getLifeShardCount() > 0 && (attributeInstance = innerPlayer.m_21051_(Attributes.f_22276_)) != null) {
                    boolean highlight;
                    int lastLifeShardHealth = 0;
                    int lastOverallHealth = 0;
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LIFE_SHARD_HEARTS);
                    RenderSystem.m_69478_();
                    double overallHealth = attributeInstance.m_22135_();
                    double maxLifeShardHealth = aetherPlayer.getLifeShardHealthAttributeModifier().m_22218_();
                    int maxDefaultHealth = Mth.m_14165_((double)(overallHealth - maxLifeShardHealth));
                    int currentOverallHealth = Mth.m_14167_((float)innerPlayer.m_21223_());
                    int currentLifeShardHealth = Mth.m_14165_((double)(maxDefaultHealth > 20 ? Mth.m_14008_((double)(currentOverallHealth - 20), (double)0.0, (double)maxLifeShardHealth) : (double)Math.min(player.m_21223_(), (float)(currentOverallHealth - maxDefaultHealth))));
                    boolean bl = highlight = guiAccessor.aether$getHealthBlinkTime() > (long)gui.m_93079_() && (guiAccessor.aether$getHealthBlinkTime() - (long)gui.m_93079_()) / 3L % 2L == 1L;
                    if (Util.m_137550_() - guiAccessor.aether$getLastHealthTime() > 1000L) {
                        lastOverallHealth = currentOverallHealth;
                        lastLifeShardHealth = currentLifeShardHealth;
                    }
                    guiAccessor.aether$getRandom().m_188584_((long)(gui.m_93079_() * 312871));
                    float displayOverallHealth = Math.max((float)overallHealth, (float)Math.max(lastOverallHealth, currentOverallHealth));
                    float displayLifeShardHealth = Math.max((float)maxLifeShardHealth, (float)Math.max(lastLifeShardHealth, currentLifeShardHealth));
                    int absorption = Mth.m_14167_((float)innerPlayer.m_6103_());
                    int healthRows = Mth.m_14167_((float)((displayOverallHealth + (float)absorption) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    int left = width / 2 - 91;
                    int top = height - 39;
                    int regen = Integer.MIN_VALUE;
                    if (innerPlayer.m_21023_(MobEffects.f_19605_)) {
                        regen = gui.m_93079_() % Mth.m_14167_((float)(displayOverallHealth + 5.0f));
                    }
                    AetherOverlays.renderHearts(poseStack, innerPlayer, gui, left, top, regen, displayOverallHealth, displayLifeShardHealth, maxDefaultHealth, currentLifeShardHealth, rowHeight, absorption, highlight);
                    RenderSystem.m_69461_();
                }
            });
        }
    }

    private static void renderHearts(PoseStack poseStack, Player player, ForgeGui gui, int left, int top, int regen, float displayOverallHealth, float displayLifeShardHealth, int maxDefaultHealth, int lifeShardHealth, int rowHeight, int absorption, boolean highlight) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        Gui.HeartType heartType = HeartTypeAccessor.callForPlayer(player);
        int overallHearts = Mth.m_14165_((double)((double)displayOverallHealth / 2.0));
        int lifeShardHearts = Mth.m_14165_((double)((double)displayLifeShardHealth / 2.0));
        int maxDefaultHearts = Mth.m_14165_((double)((double)maxDefaultHealth / 2.0));
        boolean tooManyHearts = overallHearts > 50;
        boolean tooLittleHearts = maxDefaultHearts < 10 && maxDefaultHearts > 0;
        for (int currentHeart = Math.min(overallHearts, lifeShardHearts - 1); currentHeart >= 0; --currentHeart) {
            boolean halfHeart;
            int x = left + (currentHeart + (tooLittleHearts ? overallHearts - lifeShardHearts : 0)) % 10 * 8;
            int y = top - (currentHeart + (tooManyHearts ? 0 : (maxDefaultHearts + currentHeart < 10 ? 0 : 10))) / 10 * rowHeight;
            if (Mth.m_14167_((float)player.m_21223_()) + absorption <= 4) {
                y += guiAccessor.aether$getRandom().m_188503_(2);
            }
            if (currentHeart + (maxDefaultHearts > 10 ? overallHearts - 10 : maxDefaultHearts) < overallHearts && currentHeart + Math.min(maxDefaultHearts, 10) - (tooManyHearts ? overallHearts : 0) == regen) {
                y -= 2;
            }
            int selectedContainer = currentHeart * 2;
            if (highlight && (float)selectedContainer < displayLifeShardHealth) {
                halfHeart = (float)(selectedContainer + 1) == displayLifeShardHealth;
                guiAccessor.callRenderHeart(poseStack, heartType, x, y, 0, true, halfHeart);
            }
            if (selectedContainer >= lifeShardHealth) continue;
            halfHeart = selectedContainer + 1 == lifeShardHealth;
            guiAccessor.callRenderHeart(poseStack, heartType, x, y, 0, false, halfHeart);
        }
    }
}

