/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.api.AetherMenus;
import com.aetherteam.aether.client.AetherMenuUtil;
import com.aetherteam.aether.client.AetherMusicManager;
import com.aetherteam.aether.client.WorldDisplayHelper;
import com.aetherteam.aether.client.gui.component.Builder;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.api.Menu;
import com.aetherteam.cumulus.api.MenuHelper;
import com.aetherteam.cumulus.client.CumulusClient;
import java.util.Calendar;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class MenuHooks {
    public static void prepareCustomMenus(MenuHelper menuHelper) {
        menuHelper.prepareMenu((Menu)AetherMenus.MINECRAFT_LEFT.get());
        menuHelper.prepareMenu((Menu)AetherMenus.THE_AETHER.get());
        menuHelper.prepareMenu((Menu)AetherMenus.THE_AETHER_LEFT.get());
    }

    public static void setCustomSplashText(TitleScreen screen) {
        Predicate<Calendar> condition = calendar -> calendar.get(2) + 1 == 7 && calendar.get(5) == 22;
        CumulusClient.MENU_HELPER.setCustomSplash(screen, condition, "Happy anniversary to the Aether!");
    }

    @Nullable
    public static Button setupToggleWorldButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(new Builder((Component)Component.m_237115_((String)"gui.aether.menu.button.world_preview"), pressed -> {
                AetherConfig.CLIENT.enable_world_preview.set((Object)((Boolean)AetherConfig.CLIENT.enable_world_preview.get() == false ? 1 : 0));
                AetherConfig.CLIENT.enable_world_preview.save();
                WorldDisplayHelper.toggleWorldPreview();
            }).bounds(screen.f_96543_ - 24 - MenuHooks.getButtonOffset(), 4, 20, 20).tooltip((button, poseStack, mouseX, mouseY) -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.aether.menu.preview"), mouseX + 4, mouseY + 12)));
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_world_preview_button);
            return dynamicMenuButton;
        }
        return null;
    }

    @Nullable
    public static Button setupMenuSwitchButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(new Builder((Component)Component.m_237115_((String)"gui.aether.menu.button.theme"), pressed -> {
                String menu = MenuHooks.toggleBetweenMenus();
                if (menu != null) {
                    CumulusConfig.CLIENT.active_menu.set((Object)menu);
                    CumulusConfig.CLIENT.active_menu.save();
                }
                CumulusClient.MENU_HELPER.setShouldFade(true);
                Minecraft.m_91087_().m_91152_((Screen)CumulusClient.MENU_HELPER.applyMenu(CumulusClient.MENU_HELPER.getActiveMenu()));
                Minecraft.m_91087_().m_91397_().m_120186_();
                AetherMusicManager.stopPlaying();
            }).bounds(screen.f_96543_ - 24 - MenuHooks.getButtonOffset(), 4, 20, 20).tooltip((button, poseStack, mouseX, mouseY) -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)(AetherMenuUtil.isAetherMenu() ? "gui.aether.menu.minecraft" : "gui.aether.menu.aether")), mouseX + 4, mouseY + 12)));
            dynamicMenuButton.setOffsetConfigs(AetherConfig.CLIENT.enable_world_preview_button);
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_aether_menu_button);
            return dynamicMenuButton;
        }
        return null;
    }

    @Nullable
    public static Button setupQuickLoadButton(Screen screen) {
        if (screen instanceof TitleScreen) {
            DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(new Builder((Component)Component.m_237115_((String)"gui.aether.menu.button.quick_load"), pressed -> {
                WorldDisplayHelper.enterLoadedLevel();
                Minecraft.m_91087_().m_91397_().m_120186_();
                Minecraft.m_91087_().m_91106_().m_120405_();
                AetherMusicManager.stopPlaying();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }).bounds(screen.f_96543_ - 24 - MenuHooks.getButtonOffset(), 4, 20, 20).tooltip((button, poseStack, mouseX, mouseY) -> screen.m_96602_(poseStack, (Component)Component.m_237115_((String)"gui.aether.menu.load"), mouseX + 4, mouseY + 12)));
            dynamicMenuButton.setOffsetConfigs(AetherConfig.CLIENT.enable_world_preview_button, AetherConfig.CLIENT.enable_aether_menu_button);
            dynamicMenuButton.setDisplayConfigs(AetherConfig.CLIENT.enable_world_preview, AetherConfig.CLIENT.enable_quick_load_button);
            return dynamicMenuButton;
        }
        return null;
    }

    @Nullable
    private static String toggleBetweenMenus() {
        if (AetherMenuUtil.isAetherMenu()) {
            return (String)AetherConfig.CLIENT.default_minecraft_menu.get();
        }
        if (AetherMenuUtil.isMinecraftMenu()) {
            return (String)AetherConfig.CLIENT.default_aether_menu.get();
        }
        return null;
    }

    private static int getButtonOffset() {
        return (Boolean)CumulusConfig.CLIENT.enable_menu_api.get() != false && (Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get() != false ? 62 : 0;
    }
}

