/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.hooks;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.renderer.accessory.GlovesRenderer;
import com.aetherteam.aether.client.renderer.accessory.ShieldOfRepulsionRenderer;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.miscellaneous.ShieldOfRepulsionItem;
import com.aetherteam.aether.mixin.mixins.client.accessor.ItemInHandRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HandRenderHooks {
    public static void renderGloveHandOverlay(ItemInHandRenderer itemInHandRenderer, @Nullable AbstractClientPlayer player, InteractionHand hand, float pitch, float swingProgress, float equippedProgress, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (player != null) {
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                if (!aetherPlayer.isWearingInvisibilityCloak()) {
                    CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, item -> item.m_41720_() instanceof GlovesItem).ifPresent(slotResult -> {
                        String identifier = slotResult.slotContext().identifier();
                        int id = slotResult.slotContext().index();
                        ItemStack itemStack = slotResult.stack();
                        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(identifier).ifPresent(stacksHandler -> {
                            if (((Boolean)stacksHandler.getRenders().get(id)).booleanValue()) {
                                CuriosRendererRegistry.getRenderer((Item)itemStack.m_41720_()).ifPresent(renderer -> {
                                    if (renderer instanceof GlovesRenderer) {
                                        GlovesRenderer glovesRenderer = (GlovesRenderer)renderer;
                                        ItemStack heldItem = hand == InteractionHand.MAIN_HAND ? ((ItemInHandRendererAccessor)itemInHandRenderer).aether$getMainHandItem() : ((ItemInHandRendererAccessor)itemInHandRenderer).aether$getOffHandItem();
                                        HandRenderHooks.renderArmWithItem(itemInHandRenderer, glovesRenderer, itemStack, player, heldItem, hand, pitch, swingProgress, equippedProgress, poseStack, buffer, packedLight, HandRenderType.GLOVES);
                                    }
                                });
                            }
                        }));
                    });
                }
            });
        }
    }

    public static void renderShieldOfRepulsionHandOverlay(ItemInHandRenderer itemInHandRenderer, @Nullable AbstractClientPlayer player, InteractionHand hand, float pitch, float swingProgress, float equippedProgress, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (player != null) {
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                if (!aetherPlayer.isWearingInvisibilityCloak()) {
                    CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, item -> item.m_41720_() instanceof ShieldOfRepulsionItem).ifPresent(slotResult -> {
                        String identifier = slotResult.slotContext().identifier();
                        int id = slotResult.slotContext().index();
                        ItemStack itemStack = slotResult.stack();
                        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(identifier).ifPresent(stacksHandler -> {
                            if (((Boolean)stacksHandler.getRenders().get(id)).booleanValue()) {
                                CuriosRendererRegistry.getRenderer((Item)itemStack.m_41720_()).ifPresent(renderer -> {
                                    if (renderer instanceof ShieldOfRepulsionRenderer) {
                                        ShieldOfRepulsionRenderer shieldRenderer = (ShieldOfRepulsionRenderer)renderer;
                                        ItemStack heldItem = hand == InteractionHand.MAIN_HAND ? ((ItemInHandRendererAccessor)itemInHandRenderer).aether$getMainHandItem() : ((ItemInHandRendererAccessor)itemInHandRenderer).aether$getOffHandItem();
                                        HandRenderHooks.renderArmWithItem(itemInHandRenderer, shieldRenderer, itemStack, player, heldItem, hand, pitch, swingProgress, equippedProgress, poseStack, buffer, packedLight, HandRenderType.SHIELD_OF_REPULSION);
                                    }
                                });
                            }
                        }));
                    });
                }
            });
        }
    }

    public static void renderArmWithItem(ItemInHandRenderer itemInHandRenderer, ICurioRenderer renderer, ItemStack glovesStack, AbstractClientPlayer player, ItemStack heldItem, InteractionHand hand, float pitch, float swingProgress, float equippedProgress, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HandRenderType handRenderType) {
        if (!player.m_150108_()) {
            boolean isMainHand = hand == InteractionHand.MAIN_HAND;
            HumanoidArm humanoidarm = isMainHand ? player.m_5737_() : player.m_5737_().m_20828_();
            poseStack.m_85836_();
            if (heldItem.m_41619_()) {
                if (isMainHand) {
                    HandRenderHooks.renderPlayerArm(renderer, glovesStack, player, poseStack, buffer, combinedLight, swingProgress, equippedProgress, humanoidarm, handRenderType);
                }
            } else if (heldItem.m_150930_(Items.f_42573_)) {
                if (isMainHand && ((ItemInHandRendererAccessor)itemInHandRenderer).aether$getOffHandItem().m_41619_()) {
                    HandRenderHooks.renderTwoHandedMap(itemInHandRenderer, renderer, glovesStack, player, heldItem, poseStack, buffer, combinedLight, swingProgress, equippedProgress, pitch, handRenderType);
                } else {
                    HandRenderHooks.renderOneHandedMap(itemInHandRenderer, renderer, glovesStack, player, heldItem, poseStack, buffer, combinedLight, swingProgress, equippedProgress, humanoidarm, handRenderType);
                }
            }
            poseStack.m_85849_();
        }
    }

    public static void renderPlayerArm(ICurioRenderer renderer, ItemStack glovesStack, AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float swingProgress, float equippedProgress, HumanoidArm arm, HandRenderType handRenderType) {
        boolean isSlim = player.m_108564_().equals("slim");
        boolean flag = arm != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.m_14116_((float)swingProgress);
        float f2 = -0.3f * Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        poseStack.m_85837_((double)(f * (f2 + 0.64f)), (double)(f3 - 0.6f + equippedProgress * -0.6f), (double)(f4 - 0.72f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * 45.0f));
        float f5 = Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * f6 * 70.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * f5 * -20.0f));
        poseStack.m_85837_((double)(f * -1.0f), (double)3.6f, 3.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * 120.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(200.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * -135.0f));
        float offset = 5.6f;
        if (isSlim) {
            offset = 5.65f;
        }
        poseStack.m_85837_((double)(f * offset), (double)0.005f, 0.0);
        switch (handRenderType) {
            case GLOVES: {
                ((GlovesRenderer)renderer).renderFirstPerson(glovesStack, poseStack, buffer, combinedLight, player, arm);
                break;
            }
            case SHIELD_OF_REPULSION: {
                ((ShieldOfRepulsionRenderer)renderer).renderFirstPerson(glovesStack, poseStack, buffer, combinedLight, player, arm);
            }
        }
    }

    public static void renderTwoHandedMap(ItemInHandRenderer itemInHandRenderer, ICurioRenderer renderer, ItemStack glovesStack, AbstractClientPlayer player, ItemStack heldItem, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float swingProgress, float equippedProgress, float pitch, HandRenderType handRenderType) {
        float f = Mth.m_14116_((float)swingProgress);
        float f1 = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * Mth.m_14031_((float)(f * (float)Math.PI));
        poseStack.m_85837_(0.0, (double)(-f1 / 2.0f), (double)f2);
        float f3 = ((ItemInHandRendererAccessor)itemInHandRenderer).callCalculateMapTilt(pitch);
        poseStack.m_85837_(0.0, (double)(0.04f + equippedProgress * -1.2f + f3 * -0.5f), (double)-0.72f);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f3 * -85.0f));
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        HandRenderHooks.renderMapHand(renderer, glovesStack, player, poseStack, buffer, combinedLight, HumanoidArm.RIGHT, handRenderType);
        HandRenderHooks.renderMapHand(renderer, glovesStack, player, poseStack, buffer, combinedLight, HumanoidArm.LEFT, handRenderType);
        poseStack.m_85849_();
        float f4 = Mth.m_14031_((float)(f * (float)Math.PI));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f4 * 20.0f));
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        ((ItemInHandRendererAccessor)itemInHandRenderer).callRenderMap(poseStack, buffer, combinedLight, heldItem);
    }

    public static void renderOneHandedMap(ItemInHandRenderer itemInHandRenderer, ICurioRenderer renderer, ItemStack glovesStack, AbstractClientPlayer player, ItemStack heldItem, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float swingProgress, float equippedProgress, HumanoidArm arm, HandRenderType handRenderType) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_85837_((double)(f * 0.125f), -0.125, 0.0);
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * 10.0f));
        HandRenderHooks.renderPlayerArm(renderer, glovesStack, player, poseStack, buffer, combinedLight, swingProgress, equippedProgress, arm, handRenderType);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)(f * 0.51f), (double)(-0.08f + equippedProgress * -1.2f), -0.75);
        float f1 = Mth.m_14116_((float)swingProgress);
        float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.m_14031_((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        poseStack.m_85837_((double)(f * f3), (double)(f4 - 0.3f * f2), (double)f5);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(f2 * -45.0f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * f2 * -30.0f));
        ((ItemInHandRendererAccessor)itemInHandRenderer).callRenderMap(poseStack, buffer, combinedLight, heldItem);
        poseStack.m_85849_();
    }

    public static void renderMapHand(ICurioRenderer renderer, ItemStack glovesStack, AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm arm, HandRenderType handRenderType) {
        poseStack.m_85836_();
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(92.0f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(f * -41.0f));
        poseStack.m_85837_((double)(f * 0.3f), (double)-1.1f, (double)0.45f);
        switch (handRenderType) {
            case GLOVES: {
                ((GlovesRenderer)renderer).renderFirstPerson(glovesStack, poseStack, buffer, combinedLight, player, arm);
                break;
            }
            case SHIELD_OF_REPULSION: {
                ((ShieldOfRepulsionRenderer)renderer).renderFirstPerson(glovesStack, poseStack, buffer, combinedLight, player, arm);
            }
        }
        poseStack.m_85849_();
    }

    public static enum HandRenderType {
        GLOVES,
        SHIELD_OF_REPULSION;

    }
}

