/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.resource.DelegatingPackResources;

public class CombinedPackResources
extends DelegatingPackResources {
    private final Path source;

    public CombinedPackResources(String id, String name, PackMetadataSection packInfo, List<? extends PackResources> packs, Path sourcePack) {
        super(id, name, packInfo, packs);
        this.source = sourcePack;
    }

    public Path getSource() {
        return this.source;
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        for (String name : paths) {
            path = path.resolve(name);
        }
        return path;
    }

    public InputStream m_5542_(String pFileName) throws IOException {
        if (!pFileName.contains("/") && !pFileName.contains("\\")) {
            return this.m_5541_(pFileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected boolean m_6105_(@Nonnull String name) {
        Path path = this.resolve(name);
        return Files.exists(path, new LinkOption[0]);
    }

    @Nonnull
    protected InputStream m_5541_(@Nonnull String name) throws IOException {
        Path path = this.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Can't find resource " + name + " at " + this.getSource());
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    @Nonnull
    public String toString() {
        return String.format("%s: %s", ((Object)((Object)this)).getClass().getName(), this.getSource());
    }
}

