/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability;

import com.aetherteam.aether.capability.arrow.PhoenixArrow;
import com.aetherteam.aether.capability.arrow.PhoenixArrowCapability;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.capability.item.DroppedItemCapability;
import com.aetherteam.aether.capability.lightning.LightningTracker;
import com.aetherteam.aether.capability.lightning.LightningTrackerCapability;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.player.AetherPlayerCapability;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.capability.time.AetherTimeCapability;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.nitrogen.capability.CapabilityProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AetherCapabilities {
    public static final Capability<AetherPlayer> AETHER_PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<AetherPlayer>(){});
    public static final Capability<PhoenixArrow> PHOENIX_ARROW_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PhoenixArrow>(){});
    public static final Capability<LightningTracker> LIGHTNING_TRACKER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LightningTracker>(){});
    public static final Capability<DroppedItem> DROPPED_ITEM_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DroppedItem>(){});
    public static final Capability<AetherTime> AETHER_TIME_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<AetherTime>(){});

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(AetherPlayer.class);
        event.register(PhoenixArrow.class);
        event.register(LightningTracker.class);
        event.register(DroppedItem.class);
        event.register(AetherTime.class);
    }

    @Mod.EventBusSubscriber(modid="aether")
    public static class Registration {
        @SubscribeEvent
        public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
            LivingEntity livingEntity;
            Object object = event.getObject();
            if (object instanceof LivingEntity && (livingEntity = (LivingEntity)object) instanceof Player) {
                Player player = (Player)livingEntity;
                event.addCapability(new ResourceLocation("aether", "aether_player"), (ICapabilityProvider)new CapabilityProvider(AETHER_PLAYER_CAPABILITY, (INBTSerializable)new AetherPlayerCapability(player)));
            }
            if ((object = event.getObject()) instanceof AbstractArrow) {
                AbstractArrow abstractArrow = (AbstractArrow)object;
                event.addCapability(new ResourceLocation("aether", "phoenix_arrow"), (ICapabilityProvider)new CapabilityProvider(PHOENIX_ARROW_CAPABILITY, (INBTSerializable)new PhoenixArrowCapability(abstractArrow)));
            }
            if ((object = event.getObject()) instanceof LightningBolt) {
                LightningBolt lightningBolt = (LightningBolt)object;
                event.addCapability(new ResourceLocation("aether", "lightning_tracker"), (ICapabilityProvider)new CapabilityProvider(LIGHTNING_TRACKER_CAPABILITY, (INBTSerializable)new LightningTrackerCapability(lightningBolt)));
            }
            if ((object = event.getObject()) instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)object;
                event.addCapability(new ResourceLocation("aether", "dropped_item"), (ICapabilityProvider)new CapabilityProvider(DROPPED_ITEM_CAPABILITY, (INBTSerializable)new DroppedItemCapability(itemEntity)));
            }
        }

        @SubscribeEvent
        public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
            if (((Level)event.getObject()).m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
                event.addCapability(new ResourceLocation("aether", "aether_time"), (ICapabilityProvider)new CapabilityProvider(AETHER_TIME_CAPABILITY, (INBTSerializable)new AetherTimeCapability((Level)event.getObject())));
            }
        }
    }
}

