/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.dungeon;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.event.AetherEventDispatch;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrappedBlock
extends Block {
    private final Supplier<EntityType<?>> spawnableEntityTypeSupplier;
    private final Supplier<? extends BlockState> defaultStateSupplier;

    public TrappedBlock(Supplier<EntityType<?>> spawnableEntityTypeSupplier, Supplier<? extends BlockState> defaultStateSupplier, BlockBehaviour.Properties properties) {
        super(properties);
        this.spawnableEntityTypeSupplier = spawnableEntityTypeSupplier;
        this.defaultStateSupplier = defaultStateSupplier;
    }

    public BlockState getFacadeBlock() {
        return this.defaultStateSupplier.get();
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        if (entity instanceof Player && AetherEventDispatch.onTriggerTrap(player = (Player)entity, level, pos, state)) {
            level.m_46597_(pos, this.defaultStateSupplier.get());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float yRot = player.m_146908_() * ((float)Math.PI / 180);
                Vec3 targetVec = new Vec3((double)pos.m_123341_() + 0.5 - (double)(Mth.m_14031_((float)yRot) * 3.0f), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + (double)(Mth.m_14089_((float)yRot) * 3.0f));
                ClipContext context = new ClipContext(player.m_20182_(), targetVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
                BlockHitResult hitResult = serverLevel.m_45547_(context);
                BlockPos spawnPos = hitResult.m_82425_();
                if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    spawnPos = spawnPos.m_121945_(hitResult.m_82434_());
                }
                this.spawnableEntityTypeSupplier.get().m_20592_(serverLevel, null, null, spawnPos, MobSpawnType.TRIGGERED, false, false);
                serverLevel.m_5594_(null, pos, (SoundEvent)AetherSoundEvents.BLOCK_DUNGEON_TRAP_TRIGGER.get(), SoundSource.BLOCKS, 0.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            }
        }
    }
}

