/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.datagen.provider.server;

import earth.terrarium.ad_astra.common.entity.ILunarianTradeRecipeBuilderProvider;
import earth.terrarium.ad_astra.common.entity.LunarianMerchantOffer;
import earth.terrarium.ad_astra.common.recipe.condition.LunarianDefaultTradesCondition;
import earth.terrarium.ad_astra.common.recipe.lunarian.LunarianTradeRecipe;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        String lunarianTradePath = "lunarian_trades/";
        for (Map.Entry<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> professionEntry : LunarianMerchantOffer.DEFAULT_PROFESSION_TO_LEVELED_TRADE.entrySet()) {
            VillagerProfession profession = professionEntry.getKey();
            for (Int2ObjectMap.Entry levelEntry : professionEntry.getValue().int2ObjectEntrySet()) {
                int level = levelEntry.getIntKey();
                VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])levelEntry.getValue();
                for (int i = 0; i < listings.length; ++i) {
                    VillagerTrades.ItemListing listing = listings[i];
                    if (!(listing instanceof ILunarianTradeRecipeBuilderProvider)) continue;
                    ILunarianTradeRecipeBuilderProvider provider = (ILunarianTradeRecipeBuilderProvider)listing;
                    LunarianTradeRecipe.Builder<?> builder = provider.provideRecipeBuilder();
                    builder.profession(profession).level(level);
                    builder.addCondition(LunarianDefaultTradesCondition.INSTANCE);
                    ResourceLocation id = new ResourceLocation("ad_astra", lunarianTradePath + profession.f_35600_() + "_" + level + "_" + (i + 1) + "_" + provider.getRecipeNameSuffix());
                    consumer.accept(builder.build(id));
                }
            }
        }
        for (Int2ObjectMap.Entry levelEntry : LunarianMerchantOffer.DEFAULT_WANDERING_TRADER_TRADES.int2ObjectEntrySet()) {
            int level = levelEntry.getIntKey();
            VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])levelEntry.getValue();
            for (int i = 0; i < listings.length; ++i) {
                VillagerTrades.ItemListing listing = listings[i];
                if (!(listing instanceof ILunarianTradeRecipeBuilderProvider)) continue;
                ILunarianTradeRecipeBuilderProvider provider = (ILunarianTradeRecipeBuilderProvider)listing;
                LunarianTradeRecipe.Builder<?> builder = provider.provideRecipeBuilder();
                builder.wandring().level(level);
                builder.addCondition(LunarianDefaultTradesCondition.INSTANCE);
                ResourceLocation id = new ResourceLocation("ad_astra", lunarianTradePath + "wandering_" + level + "_" + (i + 1) + "_" + provider.getRecipeNameSuffix());
                consumer.accept(builder.build(id));
            }
        }
    }
}

