/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import com.yungnickyoung.minecraft.betterendisland.world.SpikeCacheLoader;
import com.yungnickyoung.minecraft.betterendisland.world.processor.BlockReplaceProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import com.yungnickyoung.minecraft.yungsapi.world.BlockStateRandomizer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BetterSpikeFeature {
    private static final LoadingCache<Long, List<SpikeFeature.EndSpike>> SPIKE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new SpikeCacheLoader());
    private static final List<StructureProcessor> PROCESSORS = List.of(new BlockReplaceProcessor(Blocks.f_50288_.m_49966_(), new BlockStateRandomizer(Blocks.f_50080_.m_49966_()).addBlock(Blocks.f_50723_.m_49966_(), 0.3f), false, false, false, false), new BlockReplaceProcessor(Blocks.f_50289_.m_49966_(), new BlockStateRandomizer(Blocks.f_50016_.m_49966_()).addBlock(Blocks.f_50723_.m_49966_(), 0.1f).addBlock(Blocks.f_50080_.m_49966_(), 0.1f), false, false, false, false), new BlockReplaceProcessor(Blocks.f_50500_.m_49966_(), new BlockStateRandomizer(Blocks.f_50080_.m_49966_()), false, false, false, false), new DragonEggProcessor());

    public static List<SpikeFeature.EndSpike> getSpikesForLevel(WorldGenLevel level) {
        RandomSource randomSource = RandomSource.m_216335_((long)level.m_7328_());
        long seed = randomSource.m_188505_() & 0xFFFFL;
        return (List)SPIKE_CACHE.getUnchecked((Object)seed);
    }

    public static void placeSpike(ServerLevelAccessor level, RandomSource randomSource, SpikeConfiguration config, SpikeFeature.EndSpike spike, boolean isInitialSpawn) {
        ServerLevel serverLevel;
        Pair<ResourceLocation, ResourceLocation> templates = BetterSpikeFeature.chooseTemplates(spike, isInitialSpawn, randomSource.m_188501_() < 0.2f);
        long seed = 0L;
        if (level instanceof WorldGenLevel) {
            seed = ((WorldGenLevel)level).m_7328_();
        }
        RandomSource rand = RandomSource.m_216335_((long)(seed ^ (long)spike.m_66886_() ^ (long)spike.m_66893_()));
        Rotation rotation = Rotation.m_221990_((RandomSource)rand);
        int numberTimesDragonKilled = 0;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_8586_() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.m_8586_()).betterendisland$getNumberTimesDragonKilled();
        }
        int topY = BetterEndIslandCommon.betterEnd ? 70 : 60;
        BlockPos centerPos = new BlockPos(spike.m_66886_(), topY, spike.m_66893_());
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos, rotation, (ResourceLocation)templates.getFirst(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place top spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!BetterSpikeFeature.placeTemplate(level, randomSource, centerPos = centerPos.m_6625_(67), rotation, (ResourceLocation)templates.getSecond(), numberTimesDragonKilled)) {
            BetterEndIslandCommon.LOGGER.error("Unable to place bottom spike at {}. This shouldn't happen!", (Object)centerPos);
            return;
        }
        if (!isInitialSpawn) {
            EndCrystal endCrystal = (EndCrystal)EntityType.f_20564_.m_20615_((Level)level.m_6018_());
            endCrystal.m_31052_(config.m_68122_());
            endCrystal.m_20331_(config.m_68116_());
            int crystalY = topY + ((IEndSpike)spike).betterendisland$getCrystalYOffset();
            endCrystal.m_7678_((double)spike.m_66886_() + 0.5, (double)crystalY, (double)spike.m_66893_() + 0.5, randomSource.m_188501_() * 360.0f, 0.0f);
            level.m_7967_((Entity)endCrystal);
            level.m_7731_(new BlockPos(spike.m_66886_(), crystalY - 1, spike.m_66893_()), Blocks.f_50752_.m_49966_(), 3);
        }
    }

    private static Pair<ResourceLocation, ResourceLocation> chooseTemplates(SpikeFeature.EndSpike spike, boolean isInitialSpawn, boolean isGuarded) {
        String pillarType = isInitialSpawn ? "initial" : (isGuarded ? "guarded" : "broken");
        int pillarHeight = (spike.m_66899_() - 73) / 3;
        if (pillarHeight == 10) {
            pillarHeight = 9;
        }
        String topName = "pillar_" + pillarType + "_" + pillarHeight;
        String bottomName = "pillar_bottom_" + pillarHeight;
        ((IEndSpike)spike).betterendisland$setCrystalYOffsetFromPillarHeight(pillarHeight);
        return new Pair((Object)new ResourceLocation("betterendisland", topName), (Object)new ResourceLocation("betterendisland", bottomName));
    }

    private static boolean placeTemplate(ServerLevelAccessor level, RandomSource randomSource, BlockPos centerPos, Rotation rotation, ResourceLocation id, int numberTimesDragonKilled) {
        Optional templateOptional = level.m_6018_().m_215082_().m_230407_(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        StructureTemplate template = (StructureTemplate)templateOptional.get();
        BlockPos cornerPos = centerPos.m_7918_(-template.m_163801_().m_123341_() / 2, 0, -template.m_163801_().m_123343_() / 2);
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings();
        PROCESSORS.forEach(arg_0 -> ((StructurePlaceSettings)structurePlaceSettings).m_74383_(arg_0));
        structurePlaceSettings.m_74383_((StructureProcessor)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.m_74379_(rotation);
        structurePlaceSettings.m_74385_(new BlockPos(9, 0, 9));
        template.m_230328_(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

