/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.module.StructurePoolElementTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class YungJigsawFeatureElement
extends YungJigsawPoolElement {
    public static final Codec<YungJigsawFeatureElement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(element -> element.feature), (App)YungJigsawFeatureElement.m_210538_(), YungJigsawFeatureElement.nameCodec(), YungJigsawFeatureElement.maxCountCodec(), YungJigsawFeatureElement.minRequiredDepthCodec(), YungJigsawFeatureElement.maxPossibleDepthCodec(), YungJigsawFeatureElement.isPriorityCodec(), YungJigsawFeatureElement.ignoreBoundsCodec(), YungJigsawFeatureElement.conditionCodec(), YungJigsawFeatureElement.enhancedTerrainAdaptationCodec()).apply((Applicative)builder, YungJigsawFeatureElement::new));
    private final Holder<PlacedFeature> feature;
    private final CompoundTag defaultJigsawNBT;

    public YungJigsawFeatureElement(Holder<PlacedFeature> feature, StructureTemplatePool.Projection projection, Optional<String> name, Optional<Integer> maxCount, Optional<Integer> minRequiredDepth, Optional<Integer> maxPossibleDepth, boolean isPriority, boolean ignoreBounds, StructureCondition condition, Optional<EnhancedTerrainAdaptation> enhancedTerrainAdaptation) {
        super(projection, name, maxCount, minRequiredDepth, maxPossibleDepth, isPriority, ignoreBounds, condition, enhancedTerrainAdaptation);
        this.feature = feature;
        this.defaultJigsawNBT = this.fillDefaultJigsawNBT();
    }

    public Vec3i m_213577_(StructureTemplateManager structureTemplateManager, Rotation rotation) {
        return Vec3i.f_123288_;
    }

    public List<StructureTemplate.StructureBlockInfo> m_213638_(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation, RandomSource randomSource) {
        ArrayList jigsawBlocks = Lists.newArrayList();
        jigsawBlocks.add(new StructureTemplate.StructureBlockInfo(blockPos, (BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.m_122622_((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT));
        return jigsawBlocks;
    }

    public BoundingBox m_214015_(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation) {
        Vec3i size = this.m_213577_(structureTemplateManager, rotation);
        return new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_() + size.m_123341_(), blockPos.m_123342_() + size.m_123342_(), blockPos.m_123343_() + size.m_123343_());
    }

    public boolean m_213695_(StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pos, BlockPos pivotPos, Rotation rotation, BoundingBox boundingBox, RandomSource randomSource, boolean replaceJigsaws) {
        return ((PlacedFeature)this.feature.m_203334_()).m_226357_(worldGenLevel, chunkGenerator, randomSource, pos);
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag $$0 = new CompoundTag();
        $$0.m_128359_("name", "minecraft:bottom");
        $$0.m_128359_("final_state", "minecraft:air");
        $$0.m_128359_("pool", "minecraft:empty");
        $$0.m_128359_("target", "minecraft:empty");
        $$0.m_128359_("joint", JigsawBlockEntity.JointType.ROLLABLE.m_7912_());
        return $$0;
    }

    @Override
    public StructurePoolElementType<?> m_207234_() {
        return StructurePoolElementTypeModule.YUNG_FEATURE_ELEMENT;
    }

    public String toString() {
        return String.format("YungJigsawSingle[%s][%s][%s][%s]", this.name.orElse("<unnamed>"), this.feature, this.maxCount.isPresent() ? this.maxCount.get() : "no max count", this.isPriority);
    }
}

