/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.hud.Hud;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleSession;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public final class HudRenderer {
    private final PushboxHandler pushboxHandler;
    private final CustomVertexConsumers customVertexConsumers;

    public HudRenderer(PushboxHandler pushboxHandler) {
        this.pushboxHandler = pushboxHandler;
        this.customVertexConsumers = new CustomVertexConsumers();
    }

    public void render(Hud hud, PoseStack matrixStack, float partialTicks) {
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        MinimapShaders.ensureShaders();
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        double screenScale = mc.m_91268_().m_85449_();
        ModuleRenderContext renderContext = new ModuleRenderContext(screenWidth, screenHeight, screenScale);
        this.pushboxHandler.updateAll(hud.getPushboxManager());
        if (mc.f_91080_ == null) {
            for (HudPreset hudPreset : hud.getPresetManager().getPresets()) {
                hudPreset.cancel();
            }
        }
        for (HudModule hudModule : hud.getModuleManager().getModules()) {
            this.renderModule(hudModule, hud, renderContext, matrixStack, partialTicks);
        }
        this.pushboxHandler.postUpdateAll(hud.getPushboxManager());
        RenderSystem.m_69482_();
    }

    private <MS extends ModuleSession<MS>> void renderModule(HudModule<MS> module, Hud hud, ModuleRenderContext c, PoseStack matrixStack, float partialTicks) {
        MS session = module.getCurrentSession();
        ((ModuleSession)session).prePotentialRender();
        if (!((ModuleSession)session).isActive()) {
            return;
        }
        if (module.getUsedTransform().fromOldSystem) {
            hud.getOldSystemCompatibility().convertTransform(module.getUsedTransform(), (ModuleSession<?>)session, c);
        }
        IModuleRenderer<MS> renderer = module.getRenderer();
        PushboxHandler.State currentPushState = module.getPushState();
        currentPushState.resetForModule((ModuleSession<?>)session, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyScreenEdges(currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        this.pushboxHandler.applyPushboxes(hud.getPushboxManager(), currentPushState, c.screenWidth, c.screenHeight, c.screenScale);
        c.x = currentPushState.x;
        c.y = currentPushState.y;
        c.w = ((ModuleSession)session).getWidth(c.screenScale);
        c.h = ((ModuleSession)session).getHeight(c.screenScale);
        c.flippedVertically = ((ModuleSession)session).shouldFlipVertically(c.screenHeight, c.screenScale);
        c.flippedHorizontally = ((ModuleSession)session).shouldFlipHorizontally(c.screenWidth, c.screenScale);
        renderer.render(session, c, matrixStack, partialTicks);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
    }

    public PushboxHandler getPushboxHandler() {
        return this.pushboxHandler;
    }

    public CustomVertexConsumers getCustomVertexConsumers() {
        return this.customVertexConsumers;
    }
}

