/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IAbstractSelectionList;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.gui.dropdown.IDropDownWidgetCallback;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.MinimapLogs;

public class GuiWaypoints
extends ScreenBase
implements IDropDownWidgetCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static double distanceDivided;
    private List list;
    private WaypointWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private DropDownWidget containersDD;
    private DropDownWidget worldsDD;
    private DropDownWidget setsDD;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private Button deleteButton;
    private Button editButton;
    private Button teleportButton;
    private Button disableEnableButton;
    private Button clearButton;
    private Button shareButton;

    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen) {
        this(modMain, minimapSession, par1GuiScreen, null);
    }

    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, Screen escapeScreen) {
        super(modMain, par1GuiScreen, escapeScreen, (Component)Component.m_237115_((String)"gui.xaero_waypoints"));
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.selectedListSet = new ConcurrentSkipListSet();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoContainerID = this.waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = this.waypointsManager.getAutoWorldID();
        this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
        String currentContainer = this.displayedWorld.getContainer().getRootContainer().getKey();
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.updateSortedList();
        this.list = new List();
        this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrent());
        this.m_7787_(this.list);
        this.deleteButton = new MyTinyButton(this.f_96543_ / 2 + 129, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_delete", (Object[])new Object[0]), b -> {
            if (this.isSomethingSelected()) {
                Waypoint w;
                this.undrag();
                boolean shouldRestore = true;
                for (int i : this.selectedListSet) {
                    w = this.list.getWaypoint(i);
                    if (w.isTemporary()) continue;
                    shouldRestore = false;
                    w.setTemporary(true);
                }
                if (shouldRestore) {
                    for (int i : this.selectedListSet) {
                        w = this.list.getWaypoint(i);
                        w.setTemporary(false);
                    }
                }
                try {
                    this.modMain.getSettings().saveWaypoints(this.displayedWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
        });
        this.m_142416_((GuiEventListener)this.deleteButton);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 29, 200, 20, (Component)Component.m_237110_((String)"gui.done", (Object[])new Object[0]), b -> this.goBack()));
        this.editButton = new MyTinyButton(this.f_96543_ / 2 - 203, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_add_edit", (Object[])new Object[0]), b -> {
            if (!this.isAddEditEnabled()) {
                return;
            }
            ArrayList selectedWaypoints = this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.f_96541_.m_91152_((Screen)new GuiAddWaypoint(this.modMain, this.waypointsManager, this, this.escape, selectedWaypoints, this.displayedWorld.getContainer().getRootContainer().getKey(), this.displayedWorld, this.displayedWorld.getCurrent(), selectedWaypoints.isEmpty()));
            this.list.setSelected(null);
        });
        this.m_142416_((GuiEventListener)this.editButton);
        this.teleportButton = new MyTinyButton(this.f_96543_ / 2 - 120, this.f_96544_ - 53, (Component)Component.m_237113_((String)(I18n.m_118938_((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)")), b -> {
            if (!this.canTeleport()) {
                return;
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, this);
        });
        this.m_142416_((GuiEventListener)this.teleportButton);
        this.disableEnableButton = new MyTinyButton(this.f_96543_ / 2 + 46, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_disable_enable", (Object[])new Object[0]), b -> {
            if (!this.isSomethingSelected()) {
                return;
            }
            ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList();
            if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                for (Waypoint selected : selectedWaypoints) {
                    this.displayedWorld.getCurrentSet().getList().remove(selected);
                }
                this.selectedListSet.clear();
            } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(false);
                }
            } else {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(true);
                }
            }
            this.updateSortedList();
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        });
        this.m_142416_((GuiEventListener)this.disableEnableButton);
        this.clearButton = new MyTinyButton(this.f_96543_ / 2 + 130, 32, (Component)Component.m_237110_((String)"gui.xaero_clear", (Object[])new Object[0]), b -> {
            String[] worldKeys = this.worlds.getCurrentKeys();
            String name = this.sets.getOptions()[this.sets.getCurrentSet()];
            if (this.shouldDeleteSet()) {
                this.f_96541_.m_91152_((Screen)new GuiDeleteSet(I18n.m_118938_((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.escape, this.modMain, this.minimapSession));
            } else {
                this.f_96541_.m_91152_((Screen)new GuiClearSet(I18n.m_118938_((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.escape, this.modMain, this.minimapSession));
            }
        });
        this.m_142416_((GuiEventListener)this.clearButton);
        this.m_142416_((GuiEventListener)new MyTinyButton(this.f_96543_ / 2 - 203, 32, (Component)Component.m_237110_((String)"gui.xaero_options", (Object[])new Object[0]), b -> this.f_96541_.m_91152_((Screen)new GuiWaypointsOptions(this.modMain, this.minimapSession, this, this.escape, this.displayedWorld, this.frozenAutoContainerID, this.frozenAutoWorldID))));
        this.shareButton = new MyTinyButton(this.f_96543_ / 2 - 37, this.f_96544_ - 53, (Component)Component.m_237110_((String)"gui.xaero_share", (Object[])new Object[0]), b -> {
            Waypoint selected;
            if (!this.isOneSelected()) {
                return;
            }
            Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
            if (selected != null) {
                this.minimapSession.getWaypointSharing().shareWaypoint(this, selected, this.displayedWorld);
            }
        });
        this.m_142416_((GuiEventListener)this.shareButton);
        this.containersDD = this.createContainersDropdown();
        this.m_7787_(this.containersDD);
        this.worldsDD = this.createWorldsDropdown();
        this.m_7787_(this.worldsDD);
        this.setsDD = this.createSetsDropdown();
        this.m_7787_(this.setsDD);
    }

    private DropDownWidget createSetsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.sets.getOptions()).setX(this.f_96543_ / 2 - 100).setY(33).setW(200).setSelected(this.sets.getCurrentSet()).setCallback(this).setContainer(this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_set")).build();
    }

    private DropDownWidget createContainersDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.containers.options).setX(this.f_96543_ / 2 - 202).setY(17).setW(200).setSelected(this.containers.current).setCallback(this).setContainer(this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_container")).build();
    }

    private DropDownWidget createWorldsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.worlds.options).setX(this.f_96543_ / 2 + 2).setY(17).setW(200).setSelected(this.worlds.current).setCallback(this).setContainer(this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_world")).build();
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint((int)i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentSet().getList().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    @Override
    public boolean m_6375_(double par1, double par2, int par3) {
        if (this.openDropdown == null) {
            if (Misc.inputMatchesKeyBinding(this.modMain, InputConstants.Type.MOUSE, par3, ModSettings.keyWaypoints, 0)) {
                this.goBack();
                return true;
            }
            if (par3 == 0) {
                if (par2 >= 58.0 && par2 < (double)(this.f_96544_ - 61) && this.displayedWorld.getContainer().getRootContainer().getSortType() == WaypointsSort.NONE) {
                    this.draggingFromX = (int)par1;
                    this.draggingFromY = (int)par2;
                    this.draggingFromSlot = this.list.getEntryAt(par1, par2);
                    if (this.draggingFromSlot >= this.displayedWorld.getCurrentSet().getList().size()) {
                        this.draggingFromSlot = -1;
                    }
                }
            } else {
                this.list.setSelected(null);
            }
        }
        return super.m_6375_(par1, par2, par3);
    }

    @Override
    public boolean m_6348_(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.undrag();
        if (!super.m_6348_(par1, par2, par3)) {
            return this.list.m_6348_(par1, par2, par3);
        }
        return true;
    }

    public boolean m_7920_(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (this.disableEnableButton.f_93623_) {
                    for (int i : this.selectedListSet) {
                        this.list.getWaypoint(i).setTemporary(true);
                    }
                    this.disableEnableButton.m_5716_(0.0, 0.0);
                }
                return true;
            }
            case 84: {
                if (this.teleportButton.f_93623_) {
                    this.teleportButton.m_5716_(0.0, 0.0);
                }
                return true;
            }
        }
        return super.m_7920_(par1, par2, par3);
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int par1, int par2, float par3) {
        if (this.f_96541_.f_91074_ == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.updateButtons();
        this.f_96541_.f_91065_.m_93250_(0);
        this.list.m_6305_(matrixStack, par1, par2, par3);
        super.m_6305_(matrixStack, par1, par2, par3);
    }

    @Override
    protected void renderPreDropdown(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_world_server", (Object[])new Object[0]), (int)(this.f_96543_ / 2 - 102), (int)5, (int)0xFFFFFF);
        GuiComponent.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), (int)(this.f_96543_ / 2 + 102), (int)5, (int)0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(mouseX - this.draggingFromX, 2.0) + Math.pow(mouseY - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentSet().getList().size() - 1, this.list.getEntryAt(mouseX, mouseY));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentSet().getList().get(this.draggingFromSlot);
                this.list.setSelected(null);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentSet().getList().set(i, this.displayedWorld.getCurrentSet().getList().get(i + direction));
                }
                this.displayedWorld.getCurrentSet().getList().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
            }
            int fromCenter = this.draggingFromX - ((IAbstractSelectionList)((Object)this.list)).getWidth() / 2;
            this.list.drawWaypointSlot(poseStack, this.draggingWaypoint, mouseX - 108 - fromCenter, mouseY - this.list.getItemHeight() / 4);
        }
    }

    private void updateButtons() {
        this.deleteButton.f_93623_ = this.disableEnableButton.f_93623_ = this.isSomethingSelected();
        this.shareButton.f_93623_ = this.isOneSelected();
        this.teleportButton.f_93623_ = this.canTeleport();
        this.editButton.f_93623_ = this.isAddEditEnabled();
        this.clearButton.m_93666_((Component)Component.m_237110_((String)(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear"), (Object[])new Object[0]));
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        if (this.isSomethingSelected() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            this.disableEnableButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_delete"));
            this.deleteButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_restore"));
        } else {
            this.deleteButton.m_93666_((Component)Component.m_237115_((String)"gui.xaero_delete"));
            String[] enabledisable = I18n.m_118938_((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            this.disableEnableButton.m_93666_((Component)Component.m_237113_((String)enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1]));
        }
    }

    private boolean isAddEditEnabled() {
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        return selectedWaypointsList.isEmpty() || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
    }

    private boolean isSomethingSelected() {
        return !this.selectedListSet.isEmpty();
    }

    private boolean isOneSelected() {
        return this.selectedListSet.size() == 1;
    }

    private boolean canTeleport() {
        return this.isOneSelected() && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    @Override
    public boolean onSelected(DropDownWidget menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld();
                    this.waypointsManager.setCustomContainerID(firstWorld.getContainer().getKey());
                    this.waypointsManager.setCustomWorldID(firstWorld.getId());
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.worldsDD = this.createWorldsDropdown();
                this.replaceWidget(this.worldsDD, this.worldsDD);
            } else if (menu == this.worldsDD) {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    String[] keys = this.worlds.getCurrentKeys();
                    this.waypointsManager.setCustomContainerID(keys[0]);
                    this.waypointsManager.setCustomWorldID(keys[1]);
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.updateWaypoints();
            this.list.setSelected(null);
            this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrent());
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget(this.setsDD, this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            this.list.setSelected(null);
            if (selectedIndex == menu.size() - 1) {
                MinimapLogs.LOGGER.info("New waypoint set gui");
                this.f_96541_.m_91152_((Screen)new GuiNewSet(this.modMain, this.minimapSession, this, this.escape, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrent(this.sets.getCurrentSetKey());
            this.updateSortedList();
            this.waypointsManager.updateWaypoints();
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getContainer().getRootContainer().getSortType();
        if (sortType == WaypointsSort.NONE) {
            this.waypointsSorted = this.displayedWorld.getCurrentSet().getList();
            return;
        }
        distanceDivided = this.waypointsManager.getDimensionDivision(this.displayedWorld);
        ArrayList<KeySortableByOther<Waypoint>> sortableKeys = new ArrayList<KeySortableByOther<Waypoint>>();
        Camera camera = this.f_96541_.f_91063_.m_109153_();
        for (Waypoint waypoint : this.displayedWorld.getCurrentSet().getList()) {
            sortableKeys.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{sortType == WaypointsSort.COLOR ? Integer.valueOf(waypoint.getColor()) : (sortType == WaypointsSort.ANGLE ? Double.valueOf(-waypoint.getComparisonAngleCos(camera, distanceDivided)) : (sortType == WaypointsSort.NAME ? waypoint.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? waypoint.getSymbol() : Double.valueOf(waypoint.getComparisonDistance(camera, distanceDivided)))))}));
        }
        Collections.sort(sortableKeys);
        this.waypointsSorted = new ArrayList();
        for (KeySortableByOther keySortableByOther : sortableKeys) {
            this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
        }
        if (this.displayedWorld.getContainer().getRootContainer().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        if (!super.m_7933_(par1, par2, par3)) {
            if (Misc.inputMatchesKeyBinding(this.modMain, par1 != -1 ? InputConstants.Type.KEYSYM : InputConstants.Type.SCANCODE, par1 != -1 ? par1 : par2, ModSettings.keyWaypoints, 0)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    class List
    extends ObjectSelectionList<WaypointEntry> {
        private int createdCount;

        public List() {
            super(GuiWaypoints.this.f_96541_, GuiWaypoints.this.f_96543_, GuiWaypoints.this.f_96544_, 58, Math.max(62, GuiWaypoints.this.f_96544_ - 61), 18);
            this.createEntries(this.getWaypointCount());
        }

        protected int getWaypointCount() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size();
            if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null) {
                size += GuiWaypoints.this.waypointsManager.getServerWaypoints().size();
            }
            return size;
        }

        private Waypoint getWaypoint(int slotIndex) {
            int serverWPIndex;
            Waypoint waypoint = null;
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) {
                waypoint = GuiWaypoints.this.waypointsSorted.get(slotIndex);
            } else if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null && (serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) < GuiWaypoints.this.waypointsManager.getServerWaypoints().size()) {
                waypoint = GuiWaypoints.this.waypointsManager.getServerWaypoints().get(serverWPIndex);
            }
            return waypoint;
        }

        protected boolean m_7987_(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected void m_7733_(PoseStack matrixStack) {
            GuiWaypoints.this.m_7333_(matrixStack);
        }

        private void createEntries(int count) {
            this.m_93516_();
            this.createdCount = count;
            for (int i = 0; i < count; ++i) {
                WaypointEntry entry = new WaypointEntry(i);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            }
        }

        public void m_6305_(PoseStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
            int currentCount = this.getWaypointCount();
            if (currentCount != this.createdCount) {
                this.createEntries(currentCount);
                this.m_93410_(this.m_93517_());
            }
            super.m_6305_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        }

        public boolean m_5694_() {
            if (GuiWaypoints.this.openDropdown != null || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return GuiWaypoints.this.m_7222_() == this;
        }

        public void setSelected(WaypointEntry e) {
            if (e == null) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            Waypoint waypoint = this.getWaypoint(e.index);
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = Screen.m_96638_();
            if ((currentSize > 1 || currentSize == 1 && GuiWaypoints.this.selectedListSet.first() != e.index) && !Screen.m_96637_() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = e.index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != e.index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(e.index)) {
                GuiWaypoints.this.selectedListSet.remove(e.index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = e.index;
                GuiWaypoints.this.selectedListSet.add(e.index);
            }
            super.m_6987_((AbstractSelectionList.Entry)(GuiWaypoints.this.selectedListSet.isEmpty() ? null : e));
        }

        public int getItemHeight() {
            return this.f_93387_;
        }

        public void drawWaypointSlot(PoseStack matrixStack, Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 1.0);
            GuiComponent.m_93208_((PoseStack)matrixStack, (Font)GuiWaypoints.this.f_96547_, (String)(w.getLocalizedName() + (String)(w.isDisabled() ? " \u00a74" + I18n.m_118938_((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.m_118938_((String)"gui.xaero_temporary", (Object[])new Object[0]) : ""))), (int)(p_180791_2_ + 110), (int)(p_180791_3_ + 1), (int)0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                GuiComponent.m_93208_((PoseStack)matrixStack, (Font)GuiWaypoints.this.f_96547_, (String)"*", (int)(rectX - 25), (int)(rectY - 3), (int)0xFFFFFF);
            }
            MultiBufferSource.BufferSource renderTypeBuffers = GuiWaypoints.this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
            GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(matrixStack, GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper(), w, GuiWaypoints.this.modMain.getSettings(), rectX, rectY, renderTypeBuffers, renderTypeBuffers.m_6299_(CustomRenderTypes.COLORED_WAYPOINTS_BGS));
            renderTypeBuffers.m_109911_();
            matrixStack.m_85849_();
        }

        public int getEntryAt(double x, double y) {
            WaypointEntry entry = (WaypointEntry)this.m_93412_(x, y);
            return entry == null ? -1 : entry.index;
        }

        public class WaypointEntry
        extends ObjectSelectionList.Entry<WaypointEntry> {
            private int index;

            public WaypointEntry(int index) {
                this.index = index;
            }

            public void m_6311_(PoseStack matrixStack, int index, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                Waypoint w = List.this.getWaypoint(index);
                if (w == GuiWaypoints.this.draggingWaypoint) {
                    return;
                }
                List.this.drawWaypointSlot(matrixStack, w, p_render_3_, p_render_2_);
            }

            public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    List.this.setSelected(this);
                    return true;
                }
                return false;
            }

            public Component m_142172_() {
                Waypoint w = List.this.getWaypoint(this.index);
                Object narration = "";
                if (w != null) {
                    narration = (String)narration + I18n.m_118938_((String)"narrator.select", (Object[])new Object[]{w.getName()}) + (String)(w.isDisabled() ? " " + I18n.m_118938_((String)"gui.xaero_disabled", (Object[])new Object[0]) : "") + (String)(w.isTemporary() ? " " + I18n.m_118938_((String)"gui.xaero_temporary", (Object[])new Object[0]) : "") + ", ";
                }
                if (GuiWaypoints.this.selectedListSet.size() != 1) {
                    narration = (String)narration + I18n.m_118938_((String)"narrator.select", (Object[])new Object[]{I18n.m_118938_((String)"gui.xaero_waypoints", (Object[])new Object[0]) + " " + GuiWaypoints.this.selectedListSet.size()});
                }
                return Component.m_237113_((String)narration);
            }
        }
    }
}

