/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.gui.IScreenBase;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;

public class MinimapInterfaceInstance
extends InterfaceInstance {
    private XaeroMinimapSession minimapSession;
    private IXaeroMinimap modMain;

    public MinimapInterfaceInstance(MinimapInterface inter, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        super(inter);
        this.minimapSession = minimapSession;
        this.modMain = modMain;
    }

    @Override
    public void prePotentialRender() {
        try {
            super.prePotentialRender();
            this.minimapSession.getMinimapProcessor().checkFBO();
            this.modMain.getTrackedPlayerRenderer().getCollector().update(Minecraft.m_91087_());
        }
        catch (Throwable e) {
            ((MinimapInterface)this.inter).setCrashedWith(e);
            ((MinimapInterface)this.inter).checkCrashes();
        }
    }

    @Override
    public void render(PoseStack matrixStack, int width, int height, double scale, float partial, CustomVertexConsumers cvc) {
        Minecraft mc = Minecraft.m_91087_();
        if (Misc.hasEffect((Player)mc.f_91074_, Effects.NO_MINIMAP) || Misc.hasEffect((Player)mc.f_91074_, Effects.NO_MINIMAP_HARMFUL) || this.minimapSession.getMinimapProcessor().getNoMinimapMessageReceived()) {
            return;
        }
        if (this.modMain.getSettings().hideMinimapUnderScreen && mc.f_91080_ != null && !(mc.f_91080_ instanceof IScreenBase) && !(mc.f_91080_ instanceof ChatScreen) && !(mc.f_91080_ instanceof DeathScreen) || this.modMain.getSettings().hideMinimapUnderF3 && mc.f_91066_.f_92063_) {
            return;
        }
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        this.minimapSession.getMinimapProcessor().onRender(matrixStack, this.inter.getX(), this.inter.getY(), width, height, scale, this.getInterfaceWidth(), this.getW(scale), partial, cvc);
        super.render(matrixStack, width, height, scale, partial, cvc);
        MinimapRendererHelper.restoreDefaultShaderBlendState();
    }

    @Override
    public int getW(double scale) {
        return (int)((double)((float)this.getInterfaceWidth() * this.modMain.getSettings().getMinimapScale()) / scale);
    }

    @Override
    public int getH(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(double scale) {
        return this.getH(scale);
    }

    public int getInterfaceWidth() {
        return this.minimapSession.getMinimapProcessor().getMinimapSize() / 2 + 18;
    }

    @Override
    public int getSize() {
        int w = this.getInterfaceWidth();
        return w * w;
    }
}

