/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.network;

import fuzs.puzzleslib.network.Message;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class S2CBuildOffersMessage
implements Message<S2CBuildOffersMessage> {
    private int containerId;
    private Int2IntOpenHashMap idToOfferCount;

    public S2CBuildOffersMessage() {
    }

    public S2CBuildOffersMessage(int containerId, Int2IntOpenHashMap idToOfferCount) {
        this.containerId = containerId;
        this.idToOfferCount = idToOfferCount;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.m_130130_(this.idToOfferCount.size());
        for (Int2IntMap.Entry entry : this.idToOfferCount.int2IntEntrySet()) {
            buf.writeInt(entry.getIntKey());
            buf.m_130130_(entry.getIntValue());
        }
    }

    public void read(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        Int2IntOpenHashMap idToOfferCount = new Int2IntOpenHashMap();
        int length = buf.m_130242_();
        for (int i = 0; i < length; ++i) {
            idToOfferCount.put(buf.readInt(), buf.m_130242_());
        }
        this.idToOfferCount = idToOfferCount;
    }

    public Message.MessageHandler<S2CBuildOffersMessage> makeHandler() {
        return new Message.MessageHandler<S2CBuildOffersMessage>(){

            public void handle(S2CBuildOffersMessage message, Player player, Object gameInstance) {
                AbstractContainerMenu abstractContainerMenu;
                Minecraft minecraft = (Minecraft)gameInstance;
                if (message.containerId == player.f_36096_.f_38840_ && (abstractContainerMenu = player.f_36096_) instanceof TradingPostMenu) {
                    TradingPostMenu playerMenu = (TradingPostMenu)abstractContainerMenu;
                    abstractContainerMenu = minecraft.f_91080_;
                    if (abstractContainerMenu instanceof TradingPostScreen) {
                        TradingPostScreen screen = (TradingPostScreen)abstractContainerMenu;
                        playerMenu.getTraders().buildOffers(message.idToOfferCount);
                        minecraft.m_231374_(TradingPostClient.OFFER_SEARCH_TREE, (List)playerMenu.m_40075_());
                        screen.refreshSearchResults();
                    }
                }
            }
        };
    }
}

