/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.world.item;

import fuzs.thinair.helper.AirHelper;
import fuzs.thinair.helper.AirQualityLevel;
import fuzs.thinair.init.ModRegistry;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class AirBladderItem
extends Item {
    private static final String TAG_OXYGEN_LEVEL = "oxygenLevel";

    public AirBladderItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        Optional maybeCap = ModRegistry.AIR_PROTECTION_CAPABILITY.maybeGet((Object)pPlayer);
        maybeCap.ifPresent(cap -> cap.setProtected(true));
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        AirQualityLevel o2Level = (AirQualityLevel)((Object)AirHelper.getO2LevelFromLocation(livingEntity.m_146892_(), livingEntity.f_19853_).getFirst());
        stack.m_41784_().m_128359_(TAG_OXYGEN_LEVEL, o2Level.toString());
        ServerPlayer maybeSplayer = null;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer splayer;
            maybeSplayer = splayer = (ServerPlayer)livingEntity;
        }
        if (o2Level == AirQualityLevel.GREEN) {
            if (stack.m_41773_() > 0) {
                stack.m_220157_(-4, livingEntity.m_217043_(), maybeSplayer);
            }
        } else if (stack.m_41773_() < stack.m_41776_()) {
            boolean failed;
            for (int i = 0; i < 4 && !(failed = stack.m_220157_(1, livingEntity.m_217043_(), maybeSplayer)) && livingEntity.m_20146_() < livingEntity.m_6062_(); ++i) {
                livingEntity.m_20301_(livingEntity.m_20146_() + 1);
            }
        }
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        AirBladderItem.stopUsing(pStack, pLivingEntity);
        return pStack;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        AirBladderItem.stopUsing(pStack, pLivingEntity);
    }

    public static void stopUsing(ItemStack stack, LivingEntity user) {
        stack.m_41749_(TAG_OXYGEN_LEVEL);
        Optional maybeCap = ModRegistry.AIR_PROTECTION_CAPABILITY.maybeGet((Object)user);
        maybeCap.ifPresent(cap -> cap.setProtected(false));
    }

    public UseAnim m_6164_(ItemStack pStack) {
        CompoundTag tag;
        UseAnim out = UseAnim.NONE;
        if (pStack.m_41773_() < pStack.m_41776_() && pStack.m_41782_() && (tag = pStack.m_41783_()).m_128425_(TAG_OXYGEN_LEVEL, 8)) {
            String o2LevelStr = tag.m_128461_(TAG_OXYGEN_LEVEL);
            try {
                AirQualityLevel o2Level = AirQualityLevel.valueOf(o2LevelStr);
                out = o2Level == AirQualityLevel.GREEN ? UseAnim.BOW : UseAnim.DRINK;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return out;
    }

    public int m_8105_(ItemStack pStack) {
        return 9001;
    }

    public int m_6473_() {
        return 1;
    }
}

