/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.handler;

import com.mojang.datafixers.util.Pair;
import fuzs.thinair.ThinAir;
import fuzs.thinair.capability.AirBubblePositionsCapability;
import fuzs.thinair.config.CommonConfig;
import fuzs.thinair.helper.AirBubble;
import fuzs.thinair.helper.AirQualityLevel;
import fuzs.thinair.init.ModRegistry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class AirBubbleTracker {
    private static final Deque<ChunkPos> SERVER_CHUNKS_TO_SCAN = new ArrayDeque<ChunkPos>();

    public static void onBlockChanged(Level world, BlockPos pos, BlockState old, BlockState now) {
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk chunk = world.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
        if (chunk != null) {
            Optional maybeCap = ModRegistry.AIR_BUBBLE_POSITIONS_CAPABILITY.maybeGet((Object)chunk);
            maybeCap.ifPresent(cap -> {
                Pair<AirQualityLevel, ForgeConfigSpec.DoubleValue> bubble;
                if (AirBubbleTracker.getPlaceBubble(old) != null) {
                    AirBubble removed = cap.getEntries().remove(pos);
                    if (removed == null) {
                        ThinAir.LOGGER.warn("Didn't remove any air bubbles at {}", (Object)pos);
                    }
                    chunk.m_8092_(true);
                }
                if ((bubble = AirBubbleTracker.getPlaceBubble(now)) != null && (Double)((ForgeConfigSpec.DoubleValue)bubble.getSecond()).get() != 0.0) {
                    AirBubble entry = new AirBubble((AirQualityLevel)((Object)((Object)bubble.getFirst())), (Double)((ForgeConfigSpec.DoubleValue)bubble.getSecond()).get());
                    AirBubble clobbered = cap.getEntries().put(pos, entry);
                    if (clobbered != null) {
                        ThinAir.LOGGER.warn("Clobbered air bubble at {}: {}", (Object)pos, (Object)clobbered);
                    }
                    chunk.m_8092_(true);
                }
            });
        }
    }

    public static void onChunkLoadServer(LevelAccessor level, ChunkAccess chunk) {
        ChunkPos chunkpos = chunk.m_7697_();
        LevelChunk chunkFromSource = level.m_7726_().m_7131_(chunkpos.f_45578_, chunkpos.f_45579_);
        if (chunkFromSource != null) {
            SERVER_CHUNKS_TO_SCAN.addLast(chunkpos);
        }
    }

    public static void consumeReqdChunksServer(Level level) {
        if (!SERVER_CHUNKS_TO_SCAN.isEmpty()) {
            Optional maybeCap;
            ChunkPos chunkpos = SERVER_CHUNKS_TO_SCAN.removeFirst();
            LevelChunk chunk = level.m_7726_().m_7131_(chunkpos.f_45578_, chunkpos.f_45579_);
            if (chunk != null && (maybeCap = ModRegistry.AIR_BUBBLE_POSITIONS_CAPABILITY.maybeGet((Object)chunk)).isPresent()) {
                AirBubblePositionsCapability cap = (AirBubblePositionsCapability)maybeCap.get();
                if (cap.getSkipCountLeft() >= 0) {
                    AirBubbleTracker.recalcChunk(chunk, cap.getEntries());
                    chunk.m_8092_(true);
                    cap.setSkipCountLeft(8);
                } else {
                    cap.setSkipCountLeft(cap.getSkipCountLeft() - 1);
                }
            }
        }
    }

    public static void onWorldClose(MinecraftServer server, LevelAccessor level) {
        SERVER_CHUNKS_TO_SCAN.clear();
    }

    public static boolean canProjectAirBubble(BlockState bs) {
        return bs.m_60713_(Blocks.f_50684_) && (Boolean)bs.m_61143_((Property)CampfireBlock.f_51227_) != false || bs.m_60713_(Blocks.f_50084_) || bs.m_60713_(Blocks.f_50139_) || bs.m_60713_(Blocks.f_50140_) || bs.m_60713_(Blocks.f_50142_);
    }

    @Nullable
    public static Pair<AirQualityLevel, ForgeConfigSpec.DoubleValue> getPlaceBubble(BlockState bs) {
        if (bs.m_60713_(Blocks.f_50684_)) {
            return new Pair((Object)AirQualityLevel.BLUE, (Object)CommonConfig.soulCampfireRange);
        }
        if (bs.m_60713_(Blocks.f_50084_)) {
            return new Pair((Object)AirQualityLevel.BLUE, (Object)CommonConfig.soulFireRange);
        }
        if (bs.m_60713_(Blocks.f_50139_) || bs.m_60713_(Blocks.f_50140_)) {
            return new Pair((Object)AirQualityLevel.BLUE, (Object)CommonConfig.soulTorchRange);
        }
        if (bs.m_60713_(Blocks.f_50142_)) {
            return new Pair((Object)AirQualityLevel.GREEN, (Object)CommonConfig.netherPortalRange);
        }
        return null;
    }

    public static void recalcChunk(LevelChunk chunk, Map<BlockPos, AirBubble> out) {
        out.clear();
        int minY = chunk.m_141937_();
        int cornerX = chunk.m_7697_().m_45604_();
        int cornerZ = chunk.m_7697_().m_45605_();
        for (int dx = 0; dx < 16; ++dx) {
            for (int dz = 0; dz < 16; ++dz) {
                int x = cornerX + dx;
                int z = cornerZ + dz;
                for (int y = minY; y < chunk.m_62953_().m_6924_(Heightmap.Types.WORLD_SURFACE, x, z); ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState bs = chunk.m_8055_(pos);
                    Pair<AirQualityLevel, ForgeConfigSpec.DoubleValue> bubble = AirBubbleTracker.getPlaceBubble(bs);
                    if (bubble == null) continue;
                    out.put(pos, new AirBubble((AirQualityLevel)((Object)bubble.getFirst()), (Double)((ForgeConfigSpec.DoubleValue)bubble.getSecond()).get()));
                }
            }
        }
    }
}

