/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.capability;

import com.google.common.collect.Maps;
import fuzs.thinair.capability.AirBubblePositionsCapability;
import fuzs.thinair.helper.AirBubble;
import fuzs.thinair.helper.AirQualityLevel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class AirBubblePositionsCapabilityImpl
implements AirBubblePositionsCapability {
    public static final String CAP_NAME = "air_bubble_positions";
    public static final String TAG_POSITIONS = "positions";
    public static final String TAG_QUALITY = "air_quality";
    public static final String TAG_RADIUS = "radius";
    public static final String TAG_SKIP_COUNT_LEFT = "skip_count_left";
    private Map<BlockPos, AirBubble> entries = Maps.newHashMap();
    private int skipCountLeft;

    @Override
    public Map<BlockPos, AirBubble> getEntries() {
        return this.entries;
    }

    @Override
    public int getSkipCountLeft() {
        return this.skipCountLeft;
    }

    @Override
    public void setSkipCountLeft(int skipCountLeft) {
        this.skipCountLeft = skipCountLeft;
    }

    public void write(CompoundTag tag) {
        ListTag positions = new ListTag();
        byte[] qualitiesArr = new byte[this.entries.size()];
        long[] radiusesArr = new long[this.entries.size()];
        int i = 0;
        for (BlockPos pos : this.entries.keySet()) {
            AirBubble entry = this.entries.get(pos);
            positions.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            qualitiesArr[i] = (byte)entry.airQuality().ordinal();
            radiusesArr[i] = Double.doubleToRawLongBits(entry.radius());
            ++i;
        }
        tag.m_128365_(TAG_POSITIONS, (Tag)positions);
        tag.m_128365_(TAG_QUALITY, (Tag)new ByteArrayTag(qualitiesArr));
        tag.m_128365_(TAG_RADIUS, (Tag)new LongArrayTag(radiusesArr));
        tag.m_128405_(TAG_SKIP_COUNT_LEFT, this.skipCountLeft);
    }

    public void read(CompoundTag tag) {
        ListTag positions = tag.m_128437_(TAG_POSITIONS, 10);
        byte[] qualities = tag.m_128463_(TAG_QUALITY);
        long[] radiuses = tag.m_128467_(TAG_RADIUS);
        this.entries = new HashMap<BlockPos, AirBubble>(positions.size());
        for (int i = 0; i < positions.size(); ++i) {
            this.entries.put(NbtUtils.m_129239_((CompoundTag)positions.m_128728_(i)), new AirBubble(AirQualityLevel.values()[qualities[i]], Double.longBitsToDouble(radiuses[i])));
        }
        this.skipCountLeft = tag.m_128451_(TAG_SKIP_COUNT_LEFT);
    }
}

