/*
 * Decompiled with CFR 0.152.
 */
package fuzs.thinair.advancements.criterion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import fuzs.thinair.advancements.AirProtectionSource;
import fuzs.thinair.advancements.AirSource;
import fuzs.thinair.helper.AirQualityLevel;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class BreatheAirTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("thinair", "breathe_bad_air");
    private static final String TAG_AIR_QUALITIES = "air_qualities";
    private static final String TAG_PROTECTION = "protection";
    private static final String TAG_AIR_SOURCE = "air_source";

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite predicate, DeserializationContext ctx) {
        EnumSet<AirQualityLevel> allowedQualities = EnumSet.noneOf(AirQualityLevel.class);
        for (JsonElement qualObj : json.getAsJsonArray(TAG_AIR_QUALITIES)) {
            String qualStr = qualObj.getAsString();
            allowedQualities.add(AirQualityLevel.valueOf(qualStr.toUpperCase(Locale.ROOT)));
        }
        Either protection = null;
        if (json.has(TAG_PROTECTION) && !json.get(TAG_PROTECTION).isJsonNull()) {
            String protectionStr = GsonHelper.m_13906_((JsonObject)json, (String)TAG_PROTECTION).toUpperCase(Locale.ROOT);
            protection = protectionStr.equals("ANY") ? Either.right((Object)Unit.INSTANCE) : Either.left((Object)((Object)AirProtectionSource.valueOf(protectionStr.toUpperCase(Locale.ROOT))));
        }
        AirSource source = null;
        if (json.has(TAG_AIR_SOURCE) && !json.get(TAG_AIR_SOURCE).isJsonNull()) {
            String sourceStr = GsonHelper.m_13906_((JsonObject)json, (String)TAG_AIR_SOURCE);
            source = AirSource.valueOf(sourceStr.toUpperCase(Locale.ROOT));
        }
        return new Instance(predicate, allowedQualities, source, protection);
    }

    public void trigger(ServerPlayer player, AirQualityLevel qualityBreathed, AirSource source, AirProtectionSource protection) {
        super.m_66234_(player, inst -> inst.test(qualityBreathed, source, protection));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final EnumSet<AirQualityLevel> allowedQualities;
        @Nullable
        protected final AirSource airSource;
        @Nullable
        protected final Either<AirProtectionSource, Unit> protection;

        public Instance(EntityPredicate.Composite predicate, EnumSet<AirQualityLevel> allowedQualities, @Nullable AirSource airSource, @Nullable Either<AirProtectionSource, Unit> protection) {
            super(ID, predicate);
            this.allowedQualities = allowedQualities;
            this.airSource = airSource;
            this.protection = protection;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject json = super.m_7683_(ctx);
            JsonArray qualities = new JsonArray();
            for (AirQualityLevel qual : this.allowedQualities) {
                qualities.add(qual.m_7912_());
            }
            json.add(BreatheAirTrigger.TAG_AIR_QUALITIES, (JsonElement)qualities);
            if (this.airSource != null) {
                json.addProperty(BreatheAirTrigger.TAG_AIR_SOURCE, this.airSource.toString().toLowerCase(Locale.ROOT));
            } else {
                json.add(BreatheAirTrigger.TAG_AIR_SOURCE, (JsonElement)JsonNull.INSTANCE);
            }
            if (this.protection != null) {
                String str = (String)this.protection.map(aps -> aps.toString().toLowerCase(Locale.ROOT), unit -> "any");
                json.addProperty(BreatheAirTrigger.TAG_PROTECTION, str);
            } else {
                json.add(BreatheAirTrigger.TAG_PROTECTION, (JsonElement)JsonNull.INSTANCE);
            }
            return json;
        }

        private boolean test(AirQualityLevel qualityBreathed, AirSource source, AirProtectionSource protection) {
            return !(!this.allowedQualities.contains((Object)qualityBreathed) || this.airSource != null && this.airSource != source || this.protection != null && (Boolean)this.protection.map(aps -> aps == protection, unit -> protection != AirProtectionSource.NONE) == false);
        }
    }
}

