/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.google.common.primitives.Floats;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.simibubi.create.foundation.utility.Components;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CameraMovePacket
implements C2SPacket,
S2CPacket {
    final int id;
    final ServerboundMovePlayerPacket.PosRot packet;

    public CameraMovePacket(ConductorEntity entity, ServerboundMovePlayerPacket.PosRot packet) {
        this.id = entity.m_19879_();
        this.packet = packet;
    }

    public CameraMovePacket(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
        this.packet = ServerboundMovePlayerPacket.PosRot.m_179687_((FriendlyByteBuf)buf);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.id);
        this.packet.m_5779_(buffer);
    }

    @Override
    public void handle(Minecraft mc) {
        ConductorEntity conductor;
        Entity entity;
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(this.id)) instanceof ConductorEntity && mc.f_91075_ == (conductor = (ConductorEntity)entity)) {
            double d0 = this.packet.m_134129_(conductor.m_20185_());
            double d1 = this.packet.m_134140_(conductor.m_20186_());
            double d2 = this.packet.m_134146_(conductor.m_20189_());
            conductor.m_217006_(d0, d1, d2);
            conductor.m_6034_(d0, d1, d2);
            float f = this.packet.m_134131_(conductor.m_146908_()) * 360.0f / 256.0f;
            float f1 = this.packet.m_134142_(conductor.m_146909_()) * 360.0f / 256.0f;
            conductor.m_6453_(d0, d1, d2, f, f1, 3, true);
            conductor.m_6853_(this.packet.m_134139_());
        }
    }

    private static boolean containsInvalidValues(double x, double y, double z, float yaw, float pitch) {
        return Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double clampHorizontal(double value) {
        return Mth.m_14008_((double)value, (double)-3.0E7, (double)3.0E7);
    }

    private static double clampVertical(double value) {
        return Mth.m_14008_((double)value, (double)-2.0E7, (double)2.0E7);
    }

    private static boolean isPlayerCollidingWithAnythingNew(ConductorEntity conductor, LevelReader world, AABB box) {
        Iterable iterable = world.m_186431_((Entity)conductor, conductor.m_20191_().m_82406_((double)1.0E-5f));
        VoxelShape voxelShape = Shapes.m_83064_((AABB)box.m_82406_((double)1.0E-5f));
        for (VoxelShape voxelShape2 : iterable) {
            if (Shapes.m_83157_((VoxelShape)voxelShape2, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.f_82689_)) continue;
            return true;
        }
        return false;
    }

    public static void teleport(ServerPlayer player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch) {
        CameraMovePacket.teleport(player, conductor, x, y, z, yaw, pitch, Collections.emptySet(), false);
    }

    public static void teleport(ServerPlayer player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch, Set<ClientboundPlayerPositionPacket.RelativeArgument> relativeSet, boolean dismountVehicle) {
        double d = relativeSet.contains(ClientboundPlayerPositionPacket.RelativeArgument.X) ? conductor.m_20185_() : 0.0;
        double e = relativeSet.contains(ClientboundPlayerPositionPacket.RelativeArgument.Y) ? conductor.m_20186_() : 0.0;
        double f = relativeSet.contains(ClientboundPlayerPositionPacket.RelativeArgument.Z) ? conductor.m_20189_() : 0.0;
        float g = relativeSet.contains(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT) ? conductor.m_146908_() : 0.0f;
        float h = relativeSet.contains(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT) ? conductor.m_146909_() : 0.0f;
        conductor.m_19890_(x, y, z, yaw, pitch);
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(conductor, new ServerboundMovePlayerPacket.PosRot(x, y, z, yaw, pitch, conductor.m_20096_())));
    }

    @Override
    public void handle(ServerPlayer sender1) {
        Entity entity = sender1.f_19853_.m_6815_(this.id);
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            if (sender1.m_8954_() == conductor) {
                boolean bl2;
                if (CameraMovePacket.containsInvalidValues(this.packet.m_134129_(0.0), this.packet.m_134140_(0.0), this.packet.m_134146_(0.0), this.packet.m_134131_(0.0f), this.packet.m_134142_(0.0f))) {
                    sender1.f_8906_.m_9942_((Component)Components.translatable((String)"multiplayer.disconnect.invalid_player_movement"));
                    return;
                }
                Level level = conductor.m_9236_();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                double d = CameraMovePacket.clampHorizontal(this.packet.m_134129_(conductor.m_20185_()));
                double e = CameraMovePacket.clampVertical(this.packet.m_134140_(conductor.m_20186_()));
                double f = CameraMovePacket.clampHorizontal(this.packet.m_134146_(conductor.m_20189_()));
                float g = Mth.m_14177_((float)this.packet.m_134131_(conductor.m_146908_()));
                float h = Mth.m_14177_((float)this.packet.m_134142_(conductor.m_146909_()));
                if (conductor.m_20159_()) {
                    conductor.m_19890_(conductor.m_20185_(), conductor.m_20186_(), conductor.m_20189_(), g, h);
                    return;
                }
                double i = conductor.m_20185_();
                double j = conductor.m_20186_();
                double k = conductor.m_20189_();
                double l = conductor.m_20186_();
                double m = d - conductor.firstGoodX;
                double n = e - conductor.firstGoodY;
                double o = f - conductor.firstGoodZ;
                double p = conductor.m_20184_().m_82556_();
                double q = m * m + n * n + o * o;
                ++conductor.receivedMovePacketCount;
                int r = conductor.receivedMovePacketCount - conductor.knownMovePacketCount;
                if (r > 5) {
                    Railways.LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)sender1.m_7755_().getString(), (Object)r);
                    r = 1;
                }
                float s = conductor.m_21255_() ? 300.0f : 100.0f;
                float f2 = s;
                if (q - p > (double)(s * (float)r)) {
                    Railways.LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{sender1.m_7755_().getString(), m, n, o});
                    CameraMovePacket.teleport(sender1, conductor, conductor.m_20185_(), conductor.m_20186_(), conductor.m_20189_(), conductor.m_146908_(), conductor.m_146909_());
                    return;
                }
                AABB aABB = conductor.m_20191_();
                m = d - conductor.lastGoodX;
                n = e - conductor.lastGoodY;
                o = f - conductor.lastGoodZ;
                boolean bl = bl2 = n > 0.0;
                if (conductor.m_20096_() && !this.packet.m_134139_() && bl2) {
                    conductor.m_6135_();
                }
                boolean bl22 = conductor.f_201939_;
                conductor.m_6478_(MoverType.PLAYER, new Vec3(m, n, o));
                double t = n;
                m = d - conductor.m_20185_();
                n = e - conductor.m_20186_();
                if (n > -0.5 || n < 0.5) {
                    n = 0.0;
                }
                o = f - conductor.m_20189_();
                q = m * m + n * n + o * o;
                boolean bl3 = false;
                if (q > 0.0625) {
                    bl3 = true;
                    return;
                }
                conductor.m_19890_(d, e, f, g, h);
                if (!conductor.f_19794_ && (bl3 && serverLevel.m_45756_((Entity)conductor, aABB) || CameraMovePacket.isPlayerCollidingWithAnythingNew(conductor, (LevelReader)serverLevel, aABB))) {
                    CameraMovePacket.teleport(sender1, conductor, i, j, k, g, h);
                    return;
                }
                conductor.doCheckFallDamage(conductor.m_20186_() - l, this.packet.m_134139_());
                conductor.m_6853_(this.packet.m_134139_());
                if (bl2) {
                    conductor.m_183634_();
                }
                conductor.lastGoodX = conductor.m_20185_();
                conductor.lastGoodY = conductor.m_20186_();
                conductor.lastGoodZ = conductor.m_20189_();
            }
        }
    }
}

