/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static MaterialColor materialColorFromDye(@Nullable DyeColor dyeColor, @NotNull MaterialColor defaultColor) {
        if (dyeColor == null) {
            return defaultColor;
        }
        return ColorUtils.materialColorFromDye(dyeColor);
    }

    public static MaterialColor materialColorFromDye(@NotNull DyeColor dyeColor) {
        return switch (dyeColor) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> MaterialColor.f_76372_;
            case DyeColor.ORANGE -> MaterialColor.f_76413_;
            case DyeColor.MAGENTA -> MaterialColor.f_76414_;
            case DyeColor.LIGHT_BLUE -> MaterialColor.f_76415_;
            case DyeColor.YELLOW -> MaterialColor.f_76416_;
            case DyeColor.LIME -> MaterialColor.f_76417_;
            case DyeColor.PINK -> MaterialColor.f_76418_;
            case DyeColor.GRAY -> MaterialColor.f_76419_;
            case DyeColor.LIGHT_GRAY -> MaterialColor.f_76420_;
            case DyeColor.CYAN -> MaterialColor.f_76421_;
            case DyeColor.PURPLE -> MaterialColor.f_76422_;
            case DyeColor.BLUE -> MaterialColor.f_76361_;
            case DyeColor.BROWN -> MaterialColor.f_76362_;
            case DyeColor.GREEN -> MaterialColor.f_76363_;
            case DyeColor.RED -> MaterialColor.f_76364_;
            case DyeColor.BLACK -> MaterialColor.f_76365_;
        };
    }

    public static String coloredName(String string) {
        return switch (string) {
            case "white" -> "White";
            case "orange" -> "Orange";
            case "magenta" -> "Magenta";
            case "light_blue" -> "Light Blue";
            case "yellow" -> "Yellow";
            case "lime" -> "Lime";
            case "pink" -> "Pink";
            case "gray" -> "Gray";
            case "light_gray" -> "Light Gray";
            case "cyan" -> "Cyan";
            case "purple" -> "Purple";
            case "blue" -> "Blue";
            case "brown" -> "Brown";
            case "green" -> "Green";
            case "red" -> "Red";
            case "black" -> "Black";
            default -> "Unknown Color";
        };
    }

    public static Item getDyeColorDyeItem(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Items.f_42535_;
            case DyeColor.ORANGE -> Items.f_42536_;
            case DyeColor.MAGENTA -> Items.f_42537_;
            case DyeColor.LIGHT_BLUE -> Items.f_42538_;
            case DyeColor.YELLOW -> Items.f_42539_;
            case DyeColor.LIME -> Items.f_42540_;
            case DyeColor.PINK -> Items.f_42489_;
            case DyeColor.GRAY -> Items.f_42490_;
            case DyeColor.LIGHT_GRAY -> Items.f_42491_;
            case DyeColor.CYAN -> Items.f_42492_;
            case DyeColor.PURPLE -> Items.f_42493_;
            case DyeColor.BLUE -> Items.f_42494_;
            case DyeColor.BROWN -> Items.f_42495_;
            case DyeColor.GREEN -> Items.f_42496_;
            case DyeColor.RED -> Items.f_42497_;
            case DyeColor.BLACK -> Items.f_42498_;
        };
    }
}

