/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.blockEntity.RemoveBlockEntityPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackBlockEntity.class}, remap=false)
public abstract class MixinTrackBlockEntity
extends SmartBlockEntity
implements IHasTrackCasing {
    @Shadow
    Map<BlockPos, BezierConnection> connections;
    protected SlabBlock trackCasing;
    protected boolean isAlternateModel;

    protected MixinTrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public SlabBlock getTrackCasing() {
        return this.trackCasing;
    }

    @Override
    public void setTrackCasing(@Nullable SlabBlock trackCasing) {
        if (trackCasing != null && CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.matches((Block)trackCasing)) {
            return;
        }
        this.trackCasing = trackCasing;
        this.notifyUpdate();
        if (this.f_58857_ != null) {
            if (this.trackCasing == null) {
                CasingCollisionUtils.manageTracks((TrackBlockEntity)this, true);
                if (!this.f_58857_.f_46443_) {
                    if (!this.connections.isEmpty() || this.m_58900_().m_61145_((Property)TrackBlock.SHAPE).orElse(TrackShape.NONE).isPortal()) {
                        return;
                    }
                    BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
                    if (blockState.m_61138_((Property)TrackBlock.HAS_BE)) {
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
                    }
                    CRPackets.PACKETS.sendTo(PlayerSelection.tracking((BlockEntity)this), (SimplePacketBase)new RemoveBlockEntityPacket(this.f_58858_));
                }
            } else if (trackCasing != null && !this.isAlternateModel) {
                CasingCollisionUtils.manageTracks((TrackBlockEntity)this, false);
            }
        }
    }

    @Override
    public boolean isAlternate() {
        return this.isAlternateModel;
    }

    @Override
    public void setAlternate(boolean alternate) {
        if (((TrackShape)this.m_58900_().m_61143_((Property)TrackBlock.SHAPE)).getModel().equals("ascending")) {
            alternate = false;
        }
        this.isAlternateModel = alternate;
        if (this.trackCasing != null) {
            CasingCollisionUtils.manageTracks((TrackBlockEntity)this, alternate);
        }
        this.notifyUpdate();
    }

    @Inject(method={"removeConnection"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", remap=true)}, cancellable=true)
    private void preventTileRemoval(BlockPos target, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            this.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"removeInboundConnections"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/RemoveBlockEntityPacket;<init>(Lnet/minecraft/core/BlockPos;)V", remap=true)}, cancellable=true)
    private void preventTileRemoval2(CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            this.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeCasing(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            tag.m_128359_("TrackCasing", Registry.f_122824_.m_7981_((Object)this.getTrackCasing()).toString());
        }
        tag.m_128379_("AlternateModel", this.isAlternate());
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void readCasing(CompoundTag tag, boolean clientPacket, CallbackInfo ci) {
        Block casingBlock;
        ResourceLocation casingName;
        if (tag.m_128441_("AlternateModel")) {
            this.setAlternate(tag.m_128471_("AlternateModel"));
        } else {
            this.setAlternate(false);
        }
        if (tag.m_128441_("TrackCasing") && Registry.f_122824_.m_7804_(casingName = ResourceLocation.m_135822_((String)tag.m_128461_("TrackCasing"), (char)':')) && (casingBlock = (Block)Registry.f_122824_.m_7745_(casingName)) instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)casingBlock;
            this.setTrackCasing(slab);
            return;
        }
        this.setTrackCasing(null);
    }

    @Inject(method={"lazyTick"}, at={@At(value="HEAD")})
    private void manageCasingCollisions(CallbackInfo ci) {
        if (this.trackCasing == null || this.isAlternateModel) {
            return;
        }
        CasingCollisionUtils.manageTracks((TrackBlockEntity)this, false);
    }
}

