/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.handcar;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.mixin_interfaces.IDeployAnywayBlockItem;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.packet.CurvedTrackHandcarPlacementPacket;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandcarItem
extends BlockItem
implements IDeployAnywayBlockItem {
    public HandcarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    private HandcarBlock getBogeyBlock() {
        return (HandcarBlock)this.m_40614_();
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Block block = state.m_60734_();
        if (block instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            TrackMaterial.TrackType trackType = track.getMaterial().trackType;
            if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
                return InteractionResult.FAIL;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.m_20154_();
            boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
            MutableObject result = new MutableObject(null);
            MutableObject resultLoc = new MutableObject(null);
            HandcarItem.withGraphLocation(level, pos, front, null, (overlap, location) -> {
                result.setValue(overlap);
                resultLoc.setValue(location);
            });
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.m_5661_((Component)Lang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            TrackGraphLocation loc = (TrackGraphLocation)resultLoc.getValue();
            if (loc == null) {
                return InteractionResult.FAIL;
            }
            boolean success = this.placeHandcar(loc, level, player, pos);
            if (success) {
                stack.m_41774_(1);
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @ApiStatus.Internal
    @NotNull
    public boolean placeHandcar(TrackGraphLocation trackGraphLocation, Level level, Player player, BlockPos soundPos) {
        TrackGraph graph = trackGraphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getFirst());
        TrackNode node2 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getSecond());
        TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        double offset = this.getBogeyBlock().getWheelPointSpacing() / 2.0;
        TravellingPoint tp1 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        TravellingPoint tp2 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        tp1.travel(graph, offset, tp1.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0)));
        tp2.travel(graph, -offset, tp2.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0)));
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.makeTrain(player.m_20148_(), graph, tp1, tp2, serverLevel);
        AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)soundPos, 1.0f, 1.0f);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.m_20154_().m_82526_(selection.direction()) < 0.0;
        BezierConnection bc = (BezierConnection)be.getConnections().get(loc.curveTarget());
        TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
        if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        CRPackets.PACKETS.send(new CurvedTrackHandcarPlacementPacket(be.m_58899_(), loc.curveTarget(), loc.segment(), front, player.m_150109_().f_35977_));
        return true;
    }

    @Nullable
    private Train makeTrain(UUID owner, TrackGraph graph, TravellingPoint tp1, TravellingPoint tp2, ServerLevel level) {
        CarriageContraption contraption = new CarriageContraption(Direction.EAST);
        SchematicWorld assemblyWorld = new SchematicWorld((Level)level);
        StructureTemplate template = level.m_215082_().m_230407_(Railways.asResource("handcar/assembly")).orElse(null);
        if (template == null) {
            return null;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings();
        template.m_230328_((ServerLevelAccessor)assemblyWorld, BlockPos.f_121853_, BlockPos.f_121853_, settings, level.m_213780_(), 2);
        assemblyWorld.getEntityStream().forEach(e -> {
            e.f_19853_ = assemblyWorld;
        });
        try {
            contraption.assemble((Level)assemblyWorld, new BlockPos(1, 1, 1));
        }
        catch (AssemblyException e2) {
            return null;
        }
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        CarriageBogey bogey = new CarriageBogey((AbstractBogeyBlock)this.getBogeyBlock(), false, null, tp1, tp2);
        Carriage carriage = new Carriage(bogey, null, 0);
        Train train = new Train(UUID.randomUUID(), owner, graph, List.of(carriage), new ArrayList(), true);
        ((IHandcarTrain)train).railways$setHandcar(true);
        carriage.setContraption((Level)level, contraption);
        train.name = Components.translatable((String)"block.railways.handcar");
        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        CRPackets.PACKETS.sendTo(PlayerSelection.all(), (SimplePacketBase)new TrainPacket(train, true));
        return train;
    }

    public static void withGraphLocation(Level level, BlockPos pos, boolean front, BezierTrackPointLocation targetBezier, BiConsumer<TrackTargetingBlockItem.OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)block;
        List trackAxes = track.getTrackAxes((BlockGetter)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.JUNCTION, null);
            return;
        }
        Direction.AxisDirection targetDirection = front ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)targetDirection, (BezierTrackPointLocation)targetBezier) : TrackGraphHelper.getGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)targetDirection, (Vec3)((Vec3)trackAxes.get(0)));
        if (location == null) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        Couple nodes = location.edge.map(arg_0 -> ((TrackGraph)location.graph).locateNode(arg_0));
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        callback.accept(TrackTargetingBlockItem.OverlapResult.VALID, location);
    }
}

