/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.wide_gauge;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlockStateGenerator;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class WideGaugeTrackBlockStateGenerator
extends CustomTrackBlockStateGenerator {
    private static final Set<String> COMPAT_MODS = ImmutableSet.of((Object)"create");

    @Override
    public <T extends Block> ModelFile getModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, BlockState state) {
        TrackShape value = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        TrackMaterial material = ((TrackBlock)ctx.getEntry()).getMaterial();
        if (value == TrackShape.NONE) {
            return prov.models().getExistingFile(prov.mcLoc("block/air"));
        }
        String textureModId = "railways";
        String resName = material.resourceName().replaceFirst("_wide", "");
        for (String modPrefix : COMPAT_MODS) {
            if (!resName.startsWith(modPrefix + "_")) continue;
            textureModId = modPrefix;
            resName = resName.replaceFirst(modPrefix + "_", "");
            break;
        }
        String prefix = "block/track/" + material.resourceName() + "/";
        String texturePrefix = "block/track/" + resName + "/";
        HashMap<String, String> textureMap = new HashMap<String, String>();
        switch (value) {
            case TE: 
            case TN: 
            case TS: 
            case TW: {
                textureMap.put("1", "portal_track_");
                textureMap.put("2", "portal_track_mip_");
                textureMap.put("3", "standard_track_");
                break;
            }
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                break;
            }
            case CR_O: 
            case XO: 
            case ZO: 
            case ND: 
            case PD: 
            case CR_D: 
            case CR_NDX: 
            case CR_NDZ: 
            case CR_PDX: 
            case CR_PDZ: {
                textureMap.put("1", "standard_track_");
                textureMap.put("2", "standard_track_mip_");
                textureMap.put("3", "standard_track_crossing_");
                break;
            }
            default: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                textureMap.put("2", "standard_track_crossing_");
            }
        }
        if (material == CRTrackMaterials.WIDE_GAUGE_ANDESITE) {
            BlockModelBuilder builder = (BlockModelBuilder)prov.models().withExistingParent(prefix + value.getModel(), Railways.asResource("block/wide_gauge_base/" + value.getModel()));
            for (String k : new String[]{"segment_left", "segment_right", "tie"}) {
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + k, Railways.asResource("block/wide_gauge_base/" + k))).texture("0", Create.asResource((String)"block/standard_track"))).texture("1", Create.asResource((String)"block/standard_track_mip"))).texture("particle", material.particle);
            }
            return builder;
        }
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + value.getModel(), Railways.asResource("block/wide_gauge_base/" + value.getModel()))).texture("particle", material.particle);
        for (String k : textureMap.keySet()) {
            builder = (BlockModelBuilder)builder.texture(k, new ResourceLocation(textureModId, texturePrefix + (String)textureMap.get(k) + resName));
        }
        for (String k : new String[]{"segment_left", "segment_right", "tie"}) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + k, Railways.asResource("block/wide_gauge_base/" + k))).texture("0", new ResourceLocation(textureModId, texturePrefix + "standard_track_" + resName))).texture("1", new ResourceLocation(textureModId, texturePrefix + "standard_track_mip_" + resName))).texture("particle", material.particle);
        }
        return builder;
    }
}

