/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowLayerBlock;
import snownee.kiwi.loader.Platform;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.compat.sereneseasons.SereneSeasonsCompat;

public class ModUtil {
    public static boolean terraforged;
    public static boolean sereneseasons;

    public static void init() {
        sereneseasons = Platform.isModLoaded((String)"sereneseasons");
        if (sereneseasons) {
            SnowRealMagic.LOGGER.info("SereneSeasons detected. Overriding melting behavior.");
        }
    }

    public static boolean shouldMelt(Level level, BlockPos pos) {
        return ModUtil.shouldMelt(level, pos, (Holder<Biome>)level.m_204166_(pos), 1);
    }

    public static boolean shouldMelt(Level level, BlockPos pos, Holder<Biome> biome, int layers) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (!level.m_46461_()) {
            return false;
        }
        if (sereneseasons) {
            return SereneSeasonsCompat.shouldMelt(level, pos, biome);
        }
        if (ModUtil.snowAndIceMeltInWarmBiomes((ResourceKey<Level>)level.m_46472_(), biome) && ((Biome)biome.m_203334_()).m_198906_(pos) && level.m_45527_(layers == 8 ? pos.m_7494_() : pos)) {
            return true;
        }
        if (layers == 1) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9) {
                return false;
            }
            if (!(level.m_8055_(pos.m_7495_()).m_60734_() instanceof SnowLayerBlock)) {
                return false;
            }
        }
        return SnowCommonConfig.snowNaturalMelt;
    }

    public static boolean snowAndIceMeltInWarmBiomes(ResourceKey<Level> dimension, Holder<Biome> biome) {
        if (SnowCommonConfig.snowAndIceMeltInWarmBiomes) {
            return true;
        }
        if (sereneseasons) {
            return SereneSeasonsCompat.isSeasonal(dimension, biome);
        }
        return false;
    }

    public static boolean coldEnoughToSnow(Level level, BlockPos pos, Holder<Biome> biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
        }
        return ((Biome)biome.m_203334_()).m_198904_(pos);
    }

    public static boolean isWinter(Level level, BlockPos pos, Holder<Biome> biome) {
        if (sereneseasons) {
            return SereneSeasonsCompat.isWinter(level, pos, biome);
        }
        return false;
    }
}

