/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;

@Mod.EventBusSubscriber
public final class GameEvents {
    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = GameEvents.onItemUse(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result.m_19077_()) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static InteractionResult onItemUse(Player player, Level worldIn, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = hitResult.m_82425_();
        BlockState state = worldIn.m_8055_(pos);
        if (!(state.m_60734_() instanceof SnowVariant)) {
            return InteractionResult.PASS;
        }
        if (player.m_36298_(Blocks.f_50125_.m_49966_())) {
            BlockState newState = ((SnowVariant)state.m_60734_()).onShovel(state, worldIn, pos);
            worldIn.m_46597_(pos, newState);
            if (!player.m_7500_() && player instanceof ServerPlayer) {
                if (newState.m_60815_()) {
                    pos = pos.m_7494_();
                }
                Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42452_));
                ItemStack held = player.m_21205_();
                held.m_41622_(1, (LivingEntity)player, stack -> stack.m_21190_(InteractionHand.MAIN_HAND));
            }
        } else {
            if (!player.m_36341_() || !SnowCommonConfig.sneakSnowball) {
                return InteractionResult.PASS;
            }
            BlockState newState = ((SnowVariant)state.m_60734_()).onShovel(state, worldIn, pos);
            worldIn.m_46597_(pos, newState);
            ItemStack snowball = new ItemStack((ItemLike)Items.f_42452_);
            if (!(player.m_7500_() && player.m_150109_().m_36063_(snowball) || player.m_36356_(snowball))) {
                player.m_36176_(snowball, false);
            }
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public static boolean onDestroyedByPlayer(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        return state.onDestroyedByPlayer(world, pos, player, false, state.m_60819_());
    }
}

