/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.screen;

import com.epherical.serverbrowser.ServerQuery;
import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.ServerPinger;
import com.epherical.serverbrowser.client.list.ServerBrowserList;
import com.epherical.serverbrowser.client.screen.FilterServerScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ServerPinger pinger = new ServerPinger();
    protected ServerBrowserList list;
    private Button joinButton;
    private Button favoriteButton;
    private Button next;
    private Button prev;
    @Nullable
    private List<Component> toolTip;
    private Component websiteStatus;
    private Screen previousScreen;
    private int page = 1;

    public ServerBrowserScreen(Screen previousScreen) {
        super(Component.m_130674_((String)""));
        this.previousScreen = previousScreen;
    }

    protected void m_7856_() {
        this.list = new ServerBrowserList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64, 36);
        this.queryServers();
        this.list.queryServers();
        this.next = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 110, 12, 60, 20, (Component)Component.m_237110_((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}), button -> {
            if (this.list.getEntries().size() >= 20) {
                ++this.page;
                this.queryServers();
                this.list.queryServers();
                button.m_93666_((Component)Component.m_237110_((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
            }
        }));
        this.prev = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 140, 12, 30, 20, (Component)Component.m_237115_((String)"serverbrowser.button.prev_page"), button -> {
            if (this.page <= 1) {
                this.page = 1;
            } else {
                --this.page;
                this.queryServers();
                this.list.queryServers();
            }
            this.next.m_93666_((Component)Component.m_237110_((String)"serverbrowser.button.next_page", (Object[])new Object[]{this.page + 1}));
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, 3, 100, 20, (Component)Component.m_237115_((String)"serverbrowser.button.register"), button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_("https://minecraft.multiplayerservers.net");
            }
            this.f_96541_.m_91152_((Screen)this);
        }, "https://minecraft.multiplayerservers.net", true))));
        this.joinButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"selectServer.select"), button -> this.joinSelectedServer()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"serverbrowser.button.filter"), button -> this.f_96541_.m_91152_((Screen)new FilterServerScreen(this))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 54, this.f_96544_ - 52, 100, 20, (Component)Component.m_237115_((String)"serverbrowser.button.history"), button -> {}));
        this.favoriteButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 70, 20, (Component)Component.m_237115_((String)"serverbrowser.button.favorite"), button -> {
            ServerList serverList = new ServerList(this.f_96541_);
            ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.m_93511_();
            if (entry instanceof ServerBrowserList.BrowsedEntry) {
                ServerBrowserList.BrowsedEntry browsedEntry = (ServerBrowserList.BrowsedEntry)entry;
                ServerData serverData = browsedEntry.getServerData();
                serverList.m_233842_(serverData, false);
                serverList.m_105442_();
                this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)this));
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 80, this.f_96544_ - 28, 156, 20, (Component)Component.m_237115_((String)"selectServer.refresh"), button -> this.refreshServerList()));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4 + 76, this.f_96544_ - 28, 75, 20, CommonComponents.f_130656_, button -> this.f_96541_.m_91152_((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()))));
        this.m_7787_((GuiEventListener)this.list);
        this.onSelectedChange();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.toolTip = null;
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.toolTip != null) {
            this.m_96597_(poseStack, this.toolTip, mouseX, mouseY);
        }
        this.next.f_93623_ = false;
        this.prev.f_93623_ = false;
        if (this.list.getEntries().size() >= 20) {
            this.next.f_93623_ = true;
        }
        if (this.page > 1) {
            this.prev.f_93623_ = true;
        }
        if (this.websiteStatus != null) {
            ServerBrowserScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.websiteStatus, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        }
    }

    public void queryServers() {
        this.websiteStatus = null;
        ServerQuery main = new ServerQuery(CommonClient.URL + "/api/v1/servers", builder -> {
            if (this.page > 1) {
                builder.addParameter("page", String.valueOf(this.page));
            }
            for (Filter filter : CommonClient.getInstance().getFilters()) {
                if (!filter.isActive()) continue;
                builder.addParameter("type", filter.getTagName());
            }
        }, throwable -> {
            this.websiteStatus = Component.m_237115_((String)"serverbrowser.error.unreachable_website");
            return "";
        }, (s, throwable) -> {
            this.websiteStatus = null;
        });
        main.buildList(main.runQuery(), this.list, false);
        String packID = CommonClient.getInstance().getConfig().bisectPackID;
        if (packID.length() > 0 && this.page <= 1) {
            ServerQuery bisect = new ServerQuery("https://www.bisecthosting.com/api/v1/public_servers", builder -> builder.addParameter("id", packID), throwable -> {
                LOGGER.warn("Could not ping bisect's servers", throwable);
                return "";
            }, (s, throwable) -> {});
            bisect.buildList(bisect.runQuery(), this.list, true);
        }
        this.websiteStatus = Component.m_237115_((String)"serverbrowser.error.unreachable_website");
    }

    public void setSelected(ServerBrowserList.Entry selected) {
        this.list.m_6987_((AbstractSelectionList.Entry)selected);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.f_93623_ = false;
        this.favoriteButton.f_93623_ = false;
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.m_93511_();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            this.joinButton.f_93623_ = true;
            this.favoriteButton.f_93623_ = true;
        }
    }

    public void joinSelectedServer() {
        ServerBrowserList.Entry entry = (ServerBrowserList.Entry)this.list.m_93511_();
        if (entry instanceof ServerBrowserList.BrowsedEntry) {
            this.join(((ServerBrowserList.BrowsedEntry)entry).getServerData());
        }
    }

    private void join(ServerData server) {
        ConnectScreen.m_169267_((Screen)this, (Minecraft)this.f_96541_, (ServerAddress)ServerAddress.m_171864_((String)server.f_105363_), (ServerData)server);
    }

    private void refreshServerList() {
        this.list.refreshServers();
    }

    public ServerPinger getPinger() {
        return this.pinger;
    }

    public void setToolTip(List<Component> toolTip) {
        this.toolTip = toolTip;
    }
}

