/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.screen;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.client.list.TagList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.http.client.utils.URIBuilder;

public class FilterServerScreen
extends Screen {
    private final Screen previousScreen;
    private Component websiteStatus;
    protected TagList list;

    protected FilterServerScreen(Screen previousScreen) {
        super((Component)Component.m_237115_((String)"serverbrowser.button.filter"));
        this.previousScreen = previousScreen;
    }

    protected void m_7856_() {
        this.queryTags();
        this.list = new TagList(this, this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 64, 25);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4 + 76, this.f_96544_ - 28, 75, 20, CommonComponents.f_130656_, button -> {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (TagList.Entry child : this.list.m_6702_()) {
                for (GuiEventListener listener : child.m_6702_()) {
                    Checkbox checkbox = (Checkbox)listener;
                    String string = checkbox.m_6035_().getString();
                    boolean active = checkbox.m_93840_();
                    filters.add(new Filter(string, active));
                }
            }
            CommonClient.getInstance().clearAndReset(filters);
            this.f_96541_.m_91152_(this.previousScreen);
        }));
        this.m_7787_((GuiEventListener)this.list);
    }

    public void queryTags() {
        this.websiteStatus = null;
        try {
            URIBuilder builder = new URIBuilder(CommonClient.URL + "/api/v1/tags");
            URL url = builder.build().toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                byte[] bytes = connection.getInputStream().readAllBytes();
                String string = new String(bytes);
                JsonArray element = JsonParser.parseString((String)string).getAsJsonArray();
                for (JsonElement jsonElement : element) {
                    JsonObject object = jsonElement.getAsJsonObject();
                    String tagName = object.get("tagName").getAsString();
                    String category = object.get("category").getAsString();
                    if (!CommonClient.getInstance().getConfig().modPackFilter.isEmpty() && category.equals("Modpack")) continue;
                    ArrayList<Filter> filterList = new ArrayList<Filter>();
                    filterList.add(new Filter(tagName));
                    CommonClient.getInstance().mergeFilters(filterList);
                }
            }
            connection.disconnect();
        }
        catch (IOException | URISyntaxException e) {
            this.websiteStatus = Component.m_237115_((String)"serverbrowser.error.unreachable_website");
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.websiteStatus != null) {
            FilterServerScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)this.websiteStatus, (int)(this.f_96543_ / 2), (int)40, (int)0xFFFFFF);
        }
    }
}

