/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client.list;

import com.epherical.serverbrowser.client.CommonClient;
import com.epherical.serverbrowser.client.screen.ServerBrowserScreen;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerBrowserList
extends ObjectSelectionList<Entry> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("ServerBrowser Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
    private static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    private static final Component INCOMPATIBLE_TOOLTIP = Component.m_237115_((String)"multiplayer.status.incompatible");
    private static final Component NO_CONNECTION_TOOLTIP = Component.m_237115_((String)"multiplayer.status.no_connection");
    private static final Component PINGING_TOOLTIP = Component.m_237115_((String)"multiplayer.status.pinging");
    private final ServerBrowserScreen screen;
    private final List<BrowsedEntry> entries = new ArrayList<BrowsedEntry>();

    public ServerBrowserList(ServerBrowserScreen screen, Minecraft minecraft, int i, int j, int k, int l, int m) {
        super(minecraft, i, j, k, l, m);
        this.screen = screen;
    }

    public void refreshServers() {
        for (BrowsedEntry entry : this.entries) {
            entry.getServerData().f_105369_ = false;
        }
    }

    public List<BrowsedEntry> getEntries() {
        return this.entries;
    }

    public void queryServers() {
        this.entries.clear();
        this.m_93516_();
    }

    public void addEntries(JsonElement jsonElement, boolean toTop) {
        JsonArray array = new JsonArray();
        array = jsonElement.getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = (JsonObject)element;
            BrowsedEntry browsedEntry = toTop ? new BrowsedEntry(this.screen, object.get("name").getAsString(), object.get("ip").getAsString(), object.get("port").getAsInt(), this.f_93386_) : new BrowsedEntry(this.screen, object, this.f_93386_);
            if (!browsedEntry.isValid()) continue;
            this.entries.add(browsedEntry);
            if (toTop) {
                this.m_239857_((AbstractSelectionList.Entry)browsedEntry);
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)browsedEntry);
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 30;
    }

    public int m_5759_() {
        return super.m_5759_() + 85;
    }

    public class BrowsedEntry
    extends Entry {
        private final ServerBrowserScreen screen;
        private final String serverName;
        private final String ipAddress;
        private final int port;
        private final Component description;
        private final List<String> tags;
        private final int rank;
        private final int bgColor;
        private ResourceLocation iconLocation;
        @Nullable
        private String lastIconB64;
        @Nullable
        private DynamicTexture icon;
        private final Minecraft minecraft;
        private ServerData serverData;
        private long lastClickTime;
        private boolean valid = true;

        public BrowsedEntry(ServerBrowserScreen screen, String serverName, String ipAddress, int port, Minecraft minecraft) {
            this.screen = screen;
            int strLen = serverName.length();
            this.serverName = strLen <= 45 ? serverName : serverName.substring(0, 45);
            this.ipAddress = ipAddress;
            this.port = port;
            this.description = Component.m_237113_((String)"Unknown server from 3rd party service.");
            this.rank = 0;
            this.bgColor = 2188223;
            this.minecraft = minecraft;
            this.tags = new ArrayList<String>();
            this.assignCommonData();
        }

        public BrowsedEntry(ServerBrowserScreen screen, JsonObject object, Minecraft minecraft) {
            this.screen = screen;
            String serverName = object.get("serverName").getAsString();
            int strLen = serverName.length();
            this.serverName = strLen <= 40 ? serverName : serverName.substring(0, 40);
            this.ipAddress = object.get("ipAddress").getAsString();
            this.port = object.get("port").getAsInt();
            String address = this.ipAddress.toLowerCase(Locale.ROOT);
            if (CommonClient.getInstance().getConfig().blacklistedServers.contains(address)) {
                this.valid = false;
            }
            this.description = Component.m_237113_((String)object.get("description").getAsString());
            ArrayList<String> tags = new ArrayList<String>();
            JsonArray array = object.getAsJsonArray("tags");
            for (JsonElement tag : array) {
                tags.add(tag.getAsString());
            }
            this.tags = tags;
            this.rank = object.get("rank").getAsInt();
            this.bgColor = object.get("backgroundColor").getAsInt();
            this.minecraft = minecraft;
            this.assignCommonData();
        }

        private void assignCommonData() {
            Object ip = this.port != 0 ? this.ipAddress + ":" + this.port : this.ipAddress;
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)ip) + "/icon");
            AbstractTexture abstractTexture = this.minecraft.m_91097_().m_174786_(this.iconLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            if (abstractTexture != MissingTextureAtlasSprite.m_118080_() && abstractTexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstractTexture;
            }
            this.serverData = new ServerData(this.serverName, (String)ip, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)ServerBrowserList.this.m_5747_();
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)"howdy partner");
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            List list2;
            Component component2;
            int latency;
            if (!this.serverData.f_105369_) {
                this.serverData.f_105369_ = true;
                this.serverData.f_105366_ = -2L;
                this.serverData.f_105365_ = CommonComponents.f_237098_;
                this.serverData.f_105364_ = CommonComponents.f_237098_;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(() -> {}));
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception var3) {
                        this.serverData.f_105366_ = -1L;
                        this.serverData.f_105365_ = CANT_CONNECT_TEXT;
                    }
                });
            }
            boolean bl = this.serverData.f_105367_ != SharedConstants.m_183709_().getProtocolVersion();
            this.minecraft.f_91062_.m_92883_(poseStack, this.serverData.f_105362_, (float)(left + 32 + 3), (float)(top + 1), 0xFFFFFF);
            List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, width - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.f_91062_.m_92877_(poseStack, (FormattedCharSequence)list.get(i), (float)(left + 32 + 3), (float)(top + 12 + 9 * i), 0x808080);
            }
            Component component = bl ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
            int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)component);
            this.minecraft.f_91062_.m_92889_(poseStack, component, (float)(left + width - textWidth - 15 - 2), (float)(top + 1), 0x808080);
            int k = 0;
            if (bl) {
                latency = 5;
                component2 = INCOMPATIBLE_TOOLTIP;
                list2 = this.serverData.f_105370_;
            } else if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
                latency = this.serverData.f_105366_ < 0L ? 5 : (this.serverData.f_105366_ < 150L ? 0 : (this.serverData.f_105366_ < 300L ? 1 : (this.serverData.f_105366_ < 600L ? 2 : (this.serverData.f_105366_ < 1000L ? 3 : 4))));
                if (this.serverData.f_105366_ < 0L) {
                    component2 = NO_CONNECTION_TOOLTIP;
                    list2 = Collections.emptyList();
                } else {
                    component2 = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
                    list2 = this.serverData.f_105370_;
                }
            } else {
                k = 1;
                latency = (int)(Util.m_137550_() / 100L + (long)index * 2L & 7L);
                if (latency > 4) {
                    latency = 8 - latency;
                }
                component2 = PINGING_TOOLTIP;
                list2 = Collections.emptyList();
            }
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(left + width - 15), (int)top, (float)(k * 10), (float)(176 + latency * 8), (int)10, (int)8, (int)256, (int)256);
            String string = this.serverData.m_105388_();
            if (!Objects.equals(string, this.lastIconB64)) {
                if (this.uploadServerIcon(string)) {
                    this.lastIconB64 = string;
                } else {
                    this.serverData.m_105383_(null);
                }
            }
            if (this.icon == null) {
                this.drawIcon(poseStack, left, top, ICON_MISSING);
            } else {
                this.drawIcon(poseStack, left, top, this.iconLocation);
            }
            int m = mouseX - left;
            int n = mouseY - top;
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || isMouseOver) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + 32), (int)(top + 32), (int)-1601138544);
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int o = mouseX - left;
                if (this.canJoin()) {
                    int currentLength = 0;
                    int maxLength = 150;
                    ArrayList<String> condensedTags = new ArrayList<String>();
                    condensedTags.add("Tags");
                    StringBuilder condenser = new StringBuilder();
                    this.tags.sort(String::compareTo);
                    for (String tag : this.tags) {
                        if (currentLength >= maxLength) {
                            currentLength = 0;
                            condensedTags.add(condenser.append(",").toString());
                            condenser = new StringBuilder();
                        } else if (condenser.length() == 0) {
                            condenser.append(tag);
                        } else {
                            condenser.append(", ").append(tag);
                        }
                        currentLength += this.minecraft.f_91062_.m_92895_(tag);
                    }
                    condensedTags.add(condenser.toString());
                    List<Component> components = condensedTags.stream().map(Component::m_237113_).collect(Collectors.toList());
                    this.screen.setToolTip(components);
                }
            }
            if (m >= width - 15 && m <= width - 5 && n >= 0 && n <= 8) {
                this.screen.setToolTip(Collections.singletonList(component2));
            } else if (m >= width - textWidth - 15 - 2 && m <= width - 15 - 2 && n >= 0 && n <= 8) {
                this.screen.setToolTip(list2);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        protected void drawIcon(PoseStack poseStack, int x, int y, ResourceLocation textureLocation) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureLocation);
            RenderSystem.m_69478_();
            GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.m_69461_();
        }

        private boolean uploadServerIcon(@Nullable String icon) {
            if (icon == null) {
                this.minecraft.m_91097_().m_118513_(this.iconLocation);
                if (this.icon != null && this.icon.m_117991_() != null) {
                    this.icon.m_117991_().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeImage = NativeImage.m_85060_((String)icon);
                    Validate.validState((nativeImage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeImage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeImage);
                    } else {
                        this.icon.m_117988_(nativeImage);
                        this.icon.m_117985_();
                    }
                    this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, var3});
                    return false;
                }
            }
            return true;
        }

        private boolean canJoin() {
            return true;
        }

        public ServerData getServerData() {
            return this.serverData;
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }
}

