/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.serverbrowser.client;

import com.epherical.epherolib.libs.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.epherical.serverbrowser.client.Filter;
import com.epherical.serverbrowser.config.OfficialServer;
import com.epherical.serverbrowser.config.SBConfig;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;

public class CommonClient {
    private static CommonClient client;
    public static String URL;
    private boolean existingSave;
    private Set<Filter> filters;
    private SBConfig config;

    public CommonClient() {
        client = this;
        this.config = new SBConfig((AbstractConfigurationLoader.Builder<?, ?>)HoconConfigurationLoader.builder(), "serverbrowser.conf");
        this.config.addSerializer(OfficialServer.class, OfficialServer.Serializer.INSTANCE);
        this.config.loadConfig("serverbrowser");
        this.filters = new LinkedHashSet<Filter>();
        this.setSettings();
        File file = new File(Minecraft.m_91087_().f_91069_, "saves");
        File[] files = file.listFiles();
        this.existingSave = files != null ? files.length > 0 : false;
    }

    public void mergeFilters(List<Filter> filter) {
        filter.removeAll(this.filters);
        this.filters.addAll(filter);
    }

    public void clearAndReset(List<Filter> filter) {
        this.filters.clear();
        this.filters.addAll(filter);
    }

    public void setSettings() {
        if (!this.config.modPackFilter.isEmpty()) {
            this.filters.add(new Filter(this.config.modPackFilter, true));
        }
    }

    public void setFilters(Set<Filter> filters) {
        this.filters = filters;
    }

    public Set<Filter> getFilters() {
        return this.filters;
    }

    public static CommonClient getInstance() {
        return client;
    }

    public void saveConfig() {
        this.config.saveConfig();
    }

    public SBConfig getConfig() {
        return this.config;
    }

    public static boolean displayCircle() {
        return CommonClient.getInstance().existingSave && CommonClient.getInstance().config.serverBrowserNotification;
    }

    static {
        URL = "https://minecraft.multiplayerservers.net";
    }
}

