/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.init.ModTags;

public class ModFertility {
    private static Set<String> springPlants = new HashSet<String>();
    private static Set<String> summerPlants = new HashSet<String>();
    private static Set<String> autumnPlants = new HashSet<String>();
    private static Set<String> winterPlants = new HashSet<String>();
    private static Set<String> allListedPlants = new HashSet<String>();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void populate() {
        springPlants.clear();
        summerPlants.clear();
        autumnPlants.clear();
        winterPlants.clear();
        allListedPlants.clear();
        seedSeasons.clear();
        ModFertility.populateSeasonCrops(ModTags.Blocks.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonCrops(ModTags.Blocks.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonCrops(ModTags.Blocks.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonCrops(ModTags.Blocks.WINTER_CROPS, winterPlants, 8);
        ModFertility.populateSeasonSeeds(ModTags.Items.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonSeeds(ModTags.Items.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonSeeds(ModTags.Items.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonSeeds(ModTags.Items.WINTER_CROPS, winterPlants, 8);
    }

    public static boolean isCropFertile(String cropName, Level level, BlockPos pos) {
        Season season = SeasonHelper.getSeasonState(level).getSeason();
        Holder biome = level.m_204166_(pos);
        if ((Integer)FertilityConfig.undergroundFertilityLevel.get() > -1 && pos.m_123342_() < (Integer)FertilityConfig.undergroundFertilityLevel.get() && !level.m_45527_(pos)) {
            return true;
        }
        if (BiomeConfig.infertileBiome((Holder<Biome>)biome)) {
            return false;
        }
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((Holder<Biome>)biome) && ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_()))) {
            return true;
        }
        if (BiomeConfig.usesTropicalSeasons((Holder<Biome>)biome)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (!((Biome)biome.m_203334_()).m_198906_(pos)) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        return !allListedPlants.contains(cropName);
    }

    private static void populateSeasonCrops(TagKey<Block> tag, Set<String> cropSet, int bitmask) {
        Registry.f_122824_.m_203431_(tag).ifPresent(blocks -> {
            for (Holder block : blocks) {
                Optional blockKey = block.m_203543_();
                if (blockKey.isEmpty()) continue;
                String plantName = ((ResourceKey)blockKey.get()).m_135782_().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    private static void populateSeasonSeeds(TagKey<Item> tag, Set<String> cropSet, int bitmask) {
        Registry.f_122827_.m_203431_(tag).ifPresent(items -> {
            for (Holder item : items) {
                Optional itemKey = item.m_203543_();
                if (itemKey.isEmpty()) continue;
                String plantName = ((ResourceKey)itemKey.get()).m_135782_().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    public static void setupTooltips(ItemTooltipEvent event) {
        String name;
        if (((Boolean)FertilityConfig.cropTooltips.get()).booleanValue() && ((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && seedSeasons.containsKey(name = Registry.f_122827_.m_7981_((Object)event.getItemStack().m_41720_()).toString())) {
            int mask = seedSeasons.get(name);
            event.getToolTip().add(Component.m_237115_((String)"desc.sereneseasons.fertile_seasons").m_130946_(":"));
            if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                event.getToolTip().add(Component.m_237115_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.year_round")).m_130940_(ChatFormatting.LIGHT_PURPLE));
            } else {
                if ((mask & 1) != 0) {
                    event.getToolTip().add(Component.m_237115_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.spring")).m_130940_(ChatFormatting.GREEN));
                }
                if ((mask & 2) != 0) {
                    event.getToolTip().add(Component.m_237115_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.summer")).m_130940_(ChatFormatting.YELLOW));
                }
                if ((mask & 4) != 0) {
                    event.getToolTip().add(Component.m_237115_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.autumn")).m_130940_(ChatFormatting.GOLD));
                }
                if ((mask & 8) != 0) {
                    event.getToolTip().add(Component.m_237115_((String)" ").m_7220_((Component)Component.m_237115_((String)"desc.sereneseasons.winter")).m_130940_(ChatFormatting.AQUA));
                }
            }
        }
    }
}

