/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.season.SeasonHooks;

@Mod.EventBusSubscriber
public class RandomUpdateHandler {
    private static void adjustWeatherFrequency(Level world, Season season) {
        if (!((Boolean)SeasonsConfig.changeWeatherFrequency.get()).booleanValue()) {
            return;
        }
        ServerLevelData serverLevelData = (ServerLevelData)world.m_6106_();
        if (season == Season.WINTER) {
            if (serverLevelData.m_6534_()) {
                serverLevelData.m_5557_(false);
            }
            if (!world.m_6106_().m_6533_() && serverLevelData.m_6531_() > 36000) {
                serverLevelData.m_6399_(world.f_46441_.m_188503_(24000) + 12000);
            }
        } else if (season == Season.SPRING) {
            if (!world.m_6106_().m_6533_() && serverLevelData.m_6531_() > 96000) {
                serverLevelData.m_6399_(world.f_46441_.m_188503_(84000) + 12000);
            }
        } else if (season == Season.SUMMER && !world.m_6106_().m_6534_() && serverLevelData.m_6558_() > 36000) {
            serverLevelData.m_6398_(world.f_46441_.m_188503_(24000) + 12000);
        }
    }

    private static void meltInChunk(ChunkMap chunkManager, LevelChunk chunkIn, Season.SubSeason subSeason) {
        ServerLevel world = chunkManager.f_140133_;
        ChunkPos chunkpos = chunkIn.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        if (world.f_46441_.m_188503_(switch (subSeason) {
            case Season.SubSeason.EARLY_SPRING -> 16;
            case Season.SubSeason.MID_SPRING -> 12;
            case Season.SubSeason.LATE_SPRING -> 8;
            default -> 4;
        }) == 0) {
            BlockPos topAirPos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING, world.m_46496_(i, 0, j, 15));
            BlockPos topGroundPos = topAirPos.m_7495_();
            BlockState aboveGroundState = world.m_8055_(topAirPos);
            BlockState groundState = world.m_8055_(topGroundPos);
            Holder biome = world.m_204166_(topAirPos);
            if (!BiomeConfig.enablesSeasonalEffects((Holder<Biome>)biome)) {
                return;
            }
            if (aboveGroundState.m_60734_() == Blocks.f_50125_) {
                if (SeasonHooks.getBiomeTemperature((Level)world, (Holder<Biome>)biome, topGroundPos) >= 0.15f) {
                    world.m_46597_(topAirPos, Blocks.f_50016_.m_49966_());
                }
            } else if (groundState.m_60734_() == Blocks.f_50126_ && SeasonHooks.getBiomeTemperature((Level)world, (Holder<Biome>)biome, topGroundPos) >= 0.15f) {
                ((IceBlock)Blocks.f_50126_).m_54168_(groundState, (Level)world, topGroundPos);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            Season.SubSeason subSeason = SeasonHelper.getSeasonState(event.level).getSubSeason();
            Season season = subSeason.getSeason();
            RandomUpdateHandler.adjustWeatherFrequency(event.level, season);
            if (season != Season.WINTER && ((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() && ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)event.level.m_46472_())) {
                ServerLevel level = (ServerLevel)event.level;
                ChunkMap chunkMap = level.m_7726_().f_8325_;
                DistanceManager distanceManager = chunkMap.m_143145_();
                int l = distanceManager.m_140816_();
                ArrayList list = Lists.newArrayListWithCapacity((int)l);
                for (ChunkHolder chunkholder : chunkMap.m_140416_()) {
                    LevelChunk levelchunk = chunkholder.m_140085_();
                    if (levelchunk == null) continue;
                    list.add(new ChunkAndHolder(levelchunk, chunkholder));
                }
                Collections.shuffle(list);
                for (ChunkAndHolder serverchunkcache$chunkandholder : list) {
                    LevelChunk levelChunk = serverchunkcache$chunkandholder.chunk;
                    ChunkPos chunkpos = levelChunk.m_7697_();
                    if (!chunkMap.m_183879_(chunkpos) && !distanceManager.shouldForceTicks(chunkpos.m_45588_()) || !level.m_183438_(chunkpos.m_45588_())) continue;
                    RandomUpdateHandler.meltInChunk(chunkMap, levelChunk, subSeason);
                }
            }
        }
    }

    record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

