/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DynamicLightSource {
    @Shadow
    public Level f_19853_;
    @Unique
    protected int lambdynlights$luminance = 0;
    @Unique
    private int lambdynlights$lastLuminance = 0;
    @Unique
    private long lambdynlights$lastUpdate = 0L;
    @Unique
    private double lambdynlights$prevX;
    @Unique
    private double lambdynlights$prevY;
    @Unique
    private double lambdynlights$prevZ;
    @Unique
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract boolean m_6060_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract BlockPos m_20183_();

    @Shadow
    public abstract boolean m_213877_();

    @Shadow
    public abstract ChunkPos m_146902_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            if (this.m_213877_()) {
                this.ryoamicLights$setDynamicLightEnabled(false);
            } else {
                this.ryoamicLights$dynamicLightTick();
                if (!((Boolean)LambDynLights.get().config.getEntitiesLightSource().get()).booleanValue() && this.m_6095_() != EntityType.f_20532_ || !DynamicLightHandlers.canLightUp((Entity)this)) {
                    this.lambdynlights$luminance = 0;
                }
                LambDynLights.updateTracking(this);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void onRemove(CallbackInfo ci) {
        if (this.f_19853_.m_5776_()) {
            this.ryoamicLights$setDynamicLightEnabled(false);
        }
    }

    @Override
    public double ryoamicLights$getDynamicLightX() {
        return this.m_20185_();
    }

    @Override
    public double ryoamicLights$getDynamicLightY() {
        return this.m_20188_();
    }

    @Override
    public double ryoamicLights$getDynamicLightZ() {
        return this.m_20189_();
    }

    @Override
    public Level ryoamicLights$getDynamicLightWorld() {
        return this.f_19853_;
    }

    @Override
    public void ryoamicLights$resetDynamicLight() {
        this.lambdynlights$lastLuminance = 0;
    }

    @Override
    public boolean ryoamicLights$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = LambDynLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambdynlights$lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lambdynlights$lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public void ryoamicLights$dynamicLightTick() {
        this.lambdynlights$luminance = this.m_6060_() ? 15 : 0;
        int luminance = DynamicLightHandlers.getLuminanceFrom((Entity)this);
        if (luminance > this.lambdynlights$luminance) {
            this.lambdynlights$luminance = luminance;
        }
    }

    @Override
    public int ryoamicLights$getLuminance() {
        return this.lambdynlights$luminance;
    }

    @Override
    public boolean ryoamicLights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.ryoamicLights$shouldUpdateDynamicLight()) {
            return false;
        }
        double deltaX = this.m_20185_() - this.lambdynlights$prevX;
        double deltaY = this.m_20186_() - this.lambdynlights$prevY;
        double deltaZ = this.m_20189_() - this.lambdynlights$prevZ;
        int luminance = this.ryoamicLights$getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lambdynlights$lastLuminance) {
            this.lambdynlights$prevX = this.m_20185_();
            this.lambdynlights$prevY = this.m_20186_();
            this.lambdynlights$prevZ = this.m_20189_();
            this.lambdynlights$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = this.m_146902_();
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.f_45578_, SectionPos.m_175552_((double)this.m_20188_()), entityChunkPos.f_45579_);
                LambDynLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                LambDynLights.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                Direction directionX = (this.m_20183_().m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (Mth.m_14080_((double)this.m_20188_()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.m_20183_().m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    LambDynLights.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    LambDynLights.updateTrackedChunks((BlockPos)chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.ryoamicLights$scheduleTrackedChunksRebuild(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void ryoamicLights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (Minecraft.m_91087_().f_91073_ == this.f_19853_) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

