/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected BlockPos f_58858_;
    @Shadow
    @Nullable
    protected Level f_58857_;
    @Shadow
    protected boolean f_58859_;
    @Unique
    private int ryoamicLights$luminance = 0;
    @Unique
    private int ryoamicLights$lastLuminance = 0;
    @Unique
    private long ryoamicLights$lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double ryoamicLights$getDynamicLightX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    @Override
    public Level ryoamicLights$getDynamicLightWorld() {
        return this.f_58857_;
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.ryoamicLights$setDynamicLightEnabled(false);
    }

    @Override
    public void ryoamicLights$resetDynamicLight() {
        this.ryoamicLights$lastLuminance = 0;
    }

    @Override
    public void ryoamicLights$dynamicLightTick() {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.f_58859_) {
            this.ryoamicLights$luminance = DynamicLightHandlers.getLuminanceFrom((BlockEntity)this);
            LambDynLights.updateTracking(this);
            if (!this.ryoamicLights$isDynamicLightEnabled()) {
                this.ryoamicLights$lastLuminance = 0;
            }
        }
    }

    @Override
    public int ryoamicLights$getLuminance() {
        return this.ryoamicLights$luminance;
    }

    @Override
    public boolean ryoamicLights$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = LambDynLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.ryoamicLights$lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.ryoamicLights$lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean ryoamicLights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.ryoamicLights$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.ryoamicLights$getLuminance();
        if (luminance != this.ryoamicLights$lastLuminance) {
            this.ryoamicLights$lastLuminance = luminance;
            if (this.lambdynlights$trackedLitChunkPos.isEmpty()) {
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(Mth.m_14042_((int)this.f_58858_.m_123341_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123342_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123343_(), (int)16));
                LambDynLights.updateTrackedChunks((BlockPos)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                Direction directionX = (this.f_58858_.m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.f_58858_.m_123342_() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.f_58858_.m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    LambDynLights.updateTrackedChunks((BlockPos)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                }
            }
            this.ryoamicLights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void ryoamicLights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

