/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.accessor.WorldRendererAccessor;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSources;
import dev.lambdaurora.lambdynlights.gui.SettingsScreen;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="ryoamiclights")
public class LambDynLights {
    public static final String NAMESPACE = "ryoamiclights";
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static LambDynLights INSTANCE;
    public final Logger logger = LogManager.getLogger((String)"ryoamiclights");
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public LambDynLights() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        if (FMLLoader.getDist().isClient()) {
            this.onInitializeClient();
        }
    }

    public void onInitializeClient() {
        ResourceManager resourceManager;
        INSTANCE = this;
        this.log("Initializing LambDynamicLights...");
        this.config.load();
        if (Minecraft.m_91087_() != null && (resourceManager = Minecraft.m_91087_().m_91098_()) instanceof ReloadableResourceManager) {
            ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)resourceManager;
            reloadableResourceManager.m_7217_((PreparableReloadListener)((ResourceManagerReloadListener)ItemLightSources::load));
        }
        MinecraftForge.EVENT_BUS.addListener(this::renderWorldLastEvent);
        ((ModContainer)ModList.get().getModContainerById(NAMESPACE).orElseThrow(RuntimeException::new)).registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, screen) -> new SettingsScreen((Screen)screen)));
        DynamicLightHandlers.registerDefaultHandlers();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderWorldLastEvent(@NotNull RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Minecraft.m_91087_().m_91307_().m_6180_("dynamic_lighting");
            LambDynLights.get().updateAll(event.getLevelRenderer());
        }
    }

    public void updateAll(@NotNull LevelRenderer renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.ryoamicLights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.m_20183_());
        int entityLuminance = ((DynamicLightSource)entity).ryoamicLights$getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.m_109883_((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = LambDynLights.maxDynamicLightLevel(pos, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.ryoamicLights$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.ryoamicLights$getDynamicLightX() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.ryoamicLights$getDynamicLightY() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.ryoamicLights$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.ryoamicLights$getDynamicLightWorld().m_5776_()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.ryoamicLights$getDynamicLightWorld().m_5776_()) {
            return false;
        }
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) break;
            lightSource.ryoamicLights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) continue;
            if (it.ryoamicLights$getLuminance() > 0) {
                it.ryoamicLights$resetDynamicLight();
            }
            it.ryoamicLights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) break;
            if (it.ryoamicLights$getLuminance() > 0) {
                it.ryoamicLights$resetDynamicLight();
            }
            it.ryoamicLights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof Player));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof Creeper);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof PrimedTnt);
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof BlockEntity);
    }

    public void log(String info) {
        this.logger.info("[LambDynLights] " + info);
    }

    public void warn(String info) {
        this.logger.warn("[LambDynLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LambDynLights.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ((WorldRendererAccessor)renderer).lambdynlights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.ryoamicLights$isDynamicLightEnabled();
        int luminance = lightSource.ryoamicLights$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.ryoamicLights$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.ryoamicLights$setDynamicLightEnabled(false);
        }
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return ItemLightSources.getLuminance(stack, submergedInWater);
    }

    public static LambDynLights get() {
        return INSTANCE;
    }
}

