/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.config.BooleanSettingEntry;
import dev.lambdaurora.lambdynlights.config.SettingEntry;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class DynamicLightsConfig {
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.FANCY;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_SELF_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_BLOCK_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    private static final ExplosiveLightingMode DEFAULT_CREEPER_LIGHTING_MODE = ExplosiveLightingMode.SIMPLE;
    private static final ExplosiveLightingMode DEFAULT_TNT_LIGHTING_MODE = ExplosiveLightingMode.OFF;
    public static final Path CONFIG_FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("lambdynlights.toml");
    protected final FileConfig config;
    private final LambDynLights mod;
    private DynamicLightsMode dynamicLightsMode;
    private final BooleanSettingEntry entitiesLightSource;
    private final BooleanSettingEntry selfLightSource;
    private final BooleanSettingEntry blockEntitiesLightSource;
    private final BooleanSettingEntry waterSensitiveCheck;
    private ExplosiveLightingMode creeperLightingMode;
    private ExplosiveLightingMode tntLightingMode;
    public final SpruceOption dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (Component)Component.m_237115_((String)"lambdynlights.tooltip.mode.1").m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"lambdynlights.tooltip.mode.2", (Object[])new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237110_((String)"lambdynlights.tooltip.mode.3", (Object[])new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.config = FileConfig.builder((Path)CONFIG_FILE_PATH).concurrent().autosave().build();
        this.entitiesLightSource = new BooleanSettingEntry("light_sources.entities", true, (Config)this.config, (Component)Component.m_237115_((String)"lambdynlights.tooltip.entities")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeEntitiesLightSource();
            }
        });
        this.selfLightSource = new BooleanSettingEntry("light_sources.self", true, (Config)this.config, (Component)Component.m_237115_((String)"lambdynlights.tooltip.self_light_source")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeLightSources(source -> source instanceof LocalPlayer && source == Minecraft.m_91087_().f_91074_);
            }
        });
        this.blockEntitiesLightSource = new BooleanSettingEntry("light_sources.block_entities", true, (Config)this.config, (Component)Component.m_237115_((String)"lambdynlights.tooltip.block_entities")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeBlockEntitiesLightSource();
            }
        });
        this.waterSensitiveCheck = new BooleanSettingEntry("light_sources.water_sensitive_check", true, (Config)this.config, (Component)Component.m_237115_((String)"lambdynlights.tooltip.water_sensitive"));
    }

    public void load() {
        this.config.load();
        String dynamicLightsModeValue = (String)this.config.getOrElse("mode", (Object)DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.entitiesLightSource.load((Config)this.config);
        this.selfLightSource.load((Config)this.config);
        this.blockEntitiesLightSource.load((Config)this.config);
        this.waterSensitiveCheck.load((Config)this.config);
        this.creeperLightingMode = ExplosiveLightingMode.byId((String)this.config.getOrElse("light_sources.creeper", (Object)DEFAULT_CREEPER_LIGHTING_MODE.getName())).orElse(DEFAULT_CREEPER_LIGHTING_MODE);
        this.tntLightingMode = ExplosiveLightingMode.byId((String)this.config.getOrElse("light_sources.tnt", (Object)DEFAULT_TNT_LIGHTING_MODE.getName())).orElse(DEFAULT_TNT_LIGHTING_MODE);
        this.mod.log("Configuration loaded.");
    }

    public void load(SettingEntry<?> settingEntry) {
        settingEntry.load((Config)this.config);
    }

    public void save() {
        this.config.save();
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.getEntitiesLightSource().set(true);
        this.getSelfLightSource().set(true);
        this.getBlockEntitiesLightSource().set(true);
        this.getWaterSensitiveCheck().set(true);
        this.setCreeperLightingMode(DEFAULT_CREEPER_LIGHTING_MODE);
        this.setTntLightingMode(DEFAULT_TNT_LIGHTING_MODE);
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        if (!mode.isEnabled()) {
            this.mod.clearLightSources();
        }
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public BooleanSettingEntry getEntitiesLightSource() {
        return this.entitiesLightSource;
    }

    public BooleanSettingEntry getSelfLightSource() {
        return this.selfLightSource;
    }

    public BooleanSettingEntry getBlockEntitiesLightSource() {
        return this.blockEntitiesLightSource;
    }

    public BooleanSettingEntry getWaterSensitiveCheck() {
        return this.waterSensitiveCheck;
    }

    public ExplosiveLightingMode getCreeperLightingMode() {
        return this.creeperLightingMode;
    }

    public void setCreeperLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.creeperLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeCreeperLightSources();
        }
        this.config.set("light_sources.creeper", (Object)lightingMode.getName());
    }

    public ExplosiveLightingMode getTntLightingMode() {
        return this.tntLightingMode;
    }

    public void setTntLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.tntLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeTntLightSources();
        }
        this.config.set("light_sources.tnt", (Object)lightingMode.getName());
    }
}

