/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.gui;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.SprucePositioned;
import org.thinkingstudio.obsidianui.SpruceTexts;
import org.thinkingstudio.obsidianui.background.Background;
import org.thinkingstudio.obsidianui.background.DirtTexturedBackground;
import org.thinkingstudio.obsidianui.option.SpruceCyclingOption;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.option.SpruceSeparatorOption;
import org.thinkingstudio.obsidianui.option.SpruceSimpleActionOption;
import org.thinkingstudio.obsidianui.screen.SpruceScreen;
import org.thinkingstudio.obsidianui.util.RenderUtil;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.SpruceButtonWidget;
import org.thinkingstudio.obsidianui.widget.SpruceLabelWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceContainerWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceOptionListWidget;
import org.thinkingstudio.obsidianui.widget.container.tabbed.SpruceTabbedWidget;
import org.thinkingstudio.ryoamiclights.DynamicLightsConfig;
import org.thinkingstudio.ryoamiclights.ExplosiveLightingMode;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.RyoamicLightsCompat;
import org.thinkingstudio.ryoamiclights.accessor.DynamicLightHandlerHolder;
import org.thinkingstudio.ryoamiclights.gui.InnerBackground;
import org.thinkingstudio.ryoamiclights.gui.LightSourceListWidget;

public class SettingsScreen
extends SpruceScreen {
    private static final Background INNER_BACKGROUND = new InnerBackground();
    private static final String DYNAMIC_LIGHT_SOURCES_KEY = "ryoamiclights.menu.light_sources";
    private final DynamicLightsConfig config;
    private final Screen parent;
    private final SpruceOption entitiesOption;
    private final SpruceOption selfOption;
    private final SpruceOption blockEntitiesOption;
    private final SpruceOption waterSensitiveOption;
    private final SpruceOption creeperLightingOption;
    private final SpruceOption tntLightingOption;
    private final SpruceOption resetOption;
    private SpruceTabbedWidget tabbedWidget;

    public SettingsScreen(@Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"ryoamiclights.menu.title"));
        this.parent = parent;
        this.config = RyoamicLights.get().config;
        this.entitiesOption = this.config.getEntitiesLightSource().getOption();
        this.selfOption = this.config.getSelfLightSource().getOption();
        this.blockEntitiesOption = this.config.getBlockEntitiesLightSource().getOption();
        this.waterSensitiveOption = this.config.getWaterSensitiveCheck().getOption();
        this.creeperLightingOption = new SpruceCyclingOption("entity.minecraft.creeper", amount -> this.config.setCreeperLightingMode(this.config.getCreeperLightingMode().next()), option -> option.getDisplayText(this.config.getCreeperLightingMode().getTranslatedText()), (Component)Component.m_237110_((String)"ryoamiclights.tooltip.creeper_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.tntLightingOption = new SpruceCyclingOption("block.minecraft.tnt", amount -> this.config.setTntLightingMode(this.config.getTntLightingMode().next()), option -> option.getDisplayText(this.config.getTntLightingMode().getTranslatedText()), (Component)Component.m_237110_((String)"ryoamiclights.tooltip.tnt_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            this.config.reset();
            Minecraft client = Minecraft.m_91087_();
            this.m_6575_(client, client.m_91268_().m_85445_(), client.m_91268_().m_85446_());
        });
    }

    public void m_7861_() {
        super.m_7861_();
        this.config.save();
    }

    private int getTextHeight() {
        Objects.requireNonNull(this.f_96547_);
        return (5 + 9) * 3 + 5;
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent dynamicLightSources = Component.m_237115_((String)DYNAMIC_LIGHT_SOURCES_KEY);
        this.tabbedWidget = new SpruceTabbedWidget(Position.origin(), this.f_96543_, this.f_96544_, null, Math.max(100, this.f_96543_ / 8), 0);
        this.tabbedWidget.getList().setBackground(DirtTexturedBackground.DARKENED);
        this.tabbedWidget.addTabEntry((Component)Component.m_237115_((String)"ryoamiclights.menu.tabs.general"), null, this.tabContainerBuilder(this::buildGeneralTab));
        this.tabbedWidget.addSeparatorEntry(null);
        this.tabbedWidget.addTabEntry((Component)Component.m_237119_().m_7220_((Component)dynamicLightSources).m_130946_(": ").m_7220_(this.entitiesOption.getPrefix()), null, this.tabContainerBuilder(this::buildEntitiesTab));
        this.tabbedWidget.addTabEntry((Component)Component.m_237119_().m_7220_((Component)dynamicLightSources).m_130946_(": ").m_7220_(this.blockEntitiesOption.getPrefix()), null, this.tabContainerBuilder(this::buildBlockEntitiesTab));
        this.m_7787_((GuiEventListener)this.tabbedWidget);
    }

    private SpruceTabbedWidget.ContainerFactory tabContainerBuilder(SpruceTabbedWidget.ContainerFactory innerFactory) {
        return (width, height) -> this.buildTabContainer(width, height, innerFactory);
    }

    private SpruceContainerWidget buildTabContainer(int width, int height, SpruceTabbedWidget.ContainerFactory factory) {
        SpruceContainerWidget container = new SpruceContainerWidget(Position.origin(), width, height);
        SpruceLabelWidget label = new SpruceLabelWidget(Position.of((int)0, (int)18), (Component)this.f_96539_.m_6881_().m_130940_(ChatFormatting.WHITE), width);
        label.setCentered(true);
        container.addChild((SpruceWidget)label);
        AbstractSpruceWidget innerWidget = factory.build(width, height - this.getTextHeight() - 29 - (RyoamicLightsCompat.isCanvasInstalled() ? 43 : 0));
        innerWidget.getPosition().setRelativeY(43);
        container.addChild((SpruceWidget)innerWidget);
        container.setBackground((matrices, widget, vOffset, mouseX, mouseY, delta) -> {
            if (this.f_96541_.f_91073_ != null) {
                this.m_93179_(matrices, widget.getX(), widget.getY(), widget.getX() + widget.getWidth(), innerWidget.getY(), -1072689136, -804253680);
                this.m_93179_(matrices, widget.getX(), innerWidget.getY() + innerWidget.getHeight(), widget.getX() + widget.getWidth(), widget.getY() + widget.getHeight(), -1072689136, -804253680);
            } else {
                DirtTexturedBackground bg = (DirtTexturedBackground)DirtTexturedBackground.NORMAL;
                RenderUtil.renderBackgroundTexture((int)widget.getX(), (int)widget.getY(), (int)widget.getWidth(), (int)(innerWidget.getY() - widget.getY()), (float)((float)vOffset / 32.0f), (int)bg.red(), (int)bg.green(), (int)bg.blue(), (int)bg.alpha());
                RenderUtil.renderBackgroundTexture((int)widget.getX(), (int)(innerWidget.getY() + innerWidget.getHeight()), (int)widget.getWidth(), (int)(widget.getHeight() - (innerWidget.getY() + innerWidget.getHeight())), (float)((float)vOffset / 32.0f), (int)bg.red(), (int)bg.green(), (int)bg.blue(), (int)bg.alpha());
            }
        });
        if (RyoamicLightsCompat.isCanvasInstalled()) {
            Objects.requireNonNull(this.f_96547_);
            SpruceLabelWidget firstLine = new SpruceLabelWidget(Position.of((int)0, (int)(height - 29 - (5 + 9) * 3)), (Component)Component.m_237115_((String)"ryoamiclights.menu.canvas.1"), width);
            firstLine.setCentered(true);
            container.addChild((SpruceWidget)firstLine);
            label = new SpruceLabelWidget(Position.of((int)0, (int)(firstLine.getY() + firstLine.getHeight() + 5)), (Component)Component.m_237115_((String)"ryoamiclights.menu.canvas.2"), width);
            label.setCentered(true);
            container.addChild((SpruceWidget)label);
        }
        container.addChild(this.resetOption.createWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155), (int)(height - 29)), 150));
        container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155 + 160), (int)(height - 29)), 150, 20, SpruceTexts.GUI_DONE, btn -> this.f_96541_.m_91152_(this.parent)));
        return container;
    }

    private SpruceOptionListWidget buildGeneralTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.of((int)0, (int)0), width, height);
        list.setBackground(INNER_BACKGROUND);
        list.addSingleOptionEntry(this.config.dynamicLightsModeOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(DYNAMIC_LIGHT_SOURCES_KEY, true, null));
        list.addOptionEntry(this.entitiesOption, this.blockEntitiesOption);
        list.addOptionEntry(this.selfOption, this.waterSensitiveOption);
        list.addOptionEntry(this.creeperLightingOption, this.tntLightingOption);
        return list;
    }

    private LightSourceListWidget buildEntitiesTab(int width, int height) {
        return this.buildLightSourcesTab(width, height, Registry.f_122826_.m_123024_().map(DynamicLightHandlerHolder::cast).collect(Collectors.toList()));
    }

    private LightSourceListWidget buildBlockEntitiesTab(int width, int height) {
        return this.buildLightSourcesTab(width, height, Registry.f_122830_.m_123024_().map(DynamicLightHandlerHolder::cast).collect(Collectors.toList()));
    }

    private LightSourceListWidget buildLightSourcesTab(int width, int height, List<DynamicLightHandlerHolder<?>> entries) {
        LightSourceListWidget list = new LightSourceListWidget(Position.of((int)0, (int)0), width, height);
        list.setBackground(INNER_BACKGROUND);
        list.addAll(entries);
        return list;
    }
}

