/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.ryoamiclights.DynamicLightSource;
import org.thinkingstudio.ryoamiclights.DynamicLightsConfig;
import org.thinkingstudio.ryoamiclights.accessor.WorldRendererAccessor;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandlers;
import org.thinkingstudio.ryoamiclights.api.item.ItemLightSources;

public class RyoamicLights {
    public static final String NAMESPACE = "ryoamiclights";
    public KeyMapping keyBinding;
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;
    private static RyoamicLights INSTANCE;
    public final Logger logger = LogManager.getLogger((String)"ryoamiclights");
    public final DynamicLightsConfig config = new DynamicLightsConfig(this);
    private final Set<DynamicLightSource> dynamicLightSources = new HashSet<DynamicLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    private long lastUpdate = System.currentTimeMillis();
    private int lastUpdateCount = 0;

    public void clientInit() {
        this.log("Initializing RyoamicLights...");
        this.config.load();
        this.keyBinding = new KeyMapping("key.ryoamiclights.dyn_light", InputConstants.Type.KEYSYM, -1, "key.ryoamiclights.category");
        DynamicLightHandlers.registerDefaultHandlers();
    }

    public void updateAll(@NotNull LevelRenderer renderer) {
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now >= this.lastUpdate + 50L) {
            this.lastUpdate = now;
            this.lastUpdateCount = 0;
            this.lightSourcesLock.readLock().lock();
            for (DynamicLightSource lightSource : this.dynamicLightSources) {
                if (!lightSource.ryoamiclights$updateDynamicLight(renderer)) continue;
                ++this.lastUpdateCount;
            }
            this.lightSourcesLock.readLock().unlock();
        }
    }

    public int getLastUpdateCount() {
        return this.lastUpdateCount;
    }

    public int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return this.getLightmapWithDynamicLight(this.getDynamicLightLevel(pos), lightmap);
    }

    public int getLightmapWithDynamicLight(@NotNull Entity entity, int lightmap) {
        int posLightLevel = (int)this.getDynamicLightLevel(entity.m_20183_());
        int entityLuminance = ((DynamicLightSource)entity).ryoamicLights$getLuminance();
        return this.getLightmapWithDynamicLight(Math.max(posLightLevel, entityLuminance), lightmap);
    }

    public int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightTexture.m_109883_((int)lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        this.lightSourcesLock.readLock().lock();
        for (DynamicLightSource lightSource : this.dynamicLightSources) {
            result = RyoamicLights.maxDynamicLightLevel(pos, lightSource, result);
        }
        this.lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull DynamicLightSource lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.ryoamicLights$getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.ryoamicLights$getDynamicLightX() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.ryoamicLights$getDynamicLightY() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.ryoamicLights$getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public void addLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.ryoamicLights$getDynamicLightWorld().m_5776_()) {
            return;
        }
        if (!this.config.getDynamicLightsMode().isEnabled()) {
            return;
        }
        if (this.containsLightSource(lightSource)) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        this.dynamicLightSources.add(lightSource);
        this.lightSourcesLock.writeLock().unlock();
    }

    public boolean containsLightSource(@NotNull DynamicLightSource lightSource) {
        if (!lightSource.ryoamicLights$getDynamicLightWorld().m_5776_()) {
            return false;
        }
        this.lightSourcesLock.readLock().lock();
        boolean result = this.dynamicLightSources.contains(lightSource);
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        this.lightSourcesLock.readLock().lock();
        int result = this.dynamicLightSources.size();
        this.lightSourcesLock.readLock().unlock();
        return result;
    }

    public void removeLightSource(@NotNull DynamicLightSource lightSource) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!it.equals(lightSource)) continue;
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) break;
            lightSource.ryoamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void clearLightSources() {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) continue;
            if (it.ryoamicLights$getLuminance() > 0) {
                it.ryoamicLights$resetDynamicLight();
            }
            it.ryoamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeLightSources(@NotNull Predicate<DynamicLightSource> filter) {
        this.lightSourcesLock.writeLock().lock();
        Iterator<DynamicLightSource> dynamicLightSources = this.dynamicLightSources.iterator();
        while (dynamicLightSources.hasNext()) {
            DynamicLightSource it = dynamicLightSources.next();
            if (!filter.test(it)) continue;
            dynamicLightSources.remove();
            if (Minecraft.m_91087_().f_91060_ == null) break;
            if (it.ryoamicLights$getLuminance() > 0) {
                it.ryoamicLights$resetDynamicLight();
            }
            it.ryoamiclights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof Entity && !(lightSource instanceof Player));
    }

    public void removeCreeperLightSources() {
        this.removeLightSources(entity -> entity instanceof Creeper);
    }

    public void removeTntLightSources() {
        this.removeLightSources(entity -> entity instanceof PrimedTnt);
    }

    public void removeBlockEntitiesLightSource() {
        this.removeLightSources(lightSource -> lightSource instanceof BlockEntity);
    }

    public void log(String info) {
        this.logger.info("[RyoamicLights] " + info);
    }

    public void warn(String info) {
        this.logger.warn("[RyoamicLights] " + info);
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        RyoamicLights.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        RyoamicLights.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            ((WorldRendererAccessor)renderer).ryoamiclights$scheduleChunkRebuild(x, y, z, false);
        }
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static void updateTracking(@NotNull DynamicLightSource lightSource) {
        boolean enabled = lightSource.ryoamicLights$isDynamicLightEnabled();
        int luminance = lightSource.ryoamicLights$getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.ryoamicLights$setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.ryoamicLights$setDynamicLightEnabled(false);
        }
    }

    private static boolean isEyeSubmergedInFluid(LivingEntity entity) {
        if (!((Boolean)RyoamicLights.get().config.getWaterSensitiveCheck().get()).booleanValue()) {
            return false;
        }
        BlockPos eyePos = new BlockPos(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        return !entity.m_9236_().m_6425_(eyePos).m_76178_();
    }

    public static int getLivingEntityLuminanceFromItems(LivingEntity entity) {
        boolean submergedInFluid = RyoamicLights.isEyeSubmergedInFluid(entity);
        int luminance = 0;
        for (ItemStack equipped : entity.m_20158_()) {
            if (equipped.m_41619_()) continue;
            luminance = Math.max(luminance, RyoamicLights.getLuminanceFromItemStack(equipped, submergedInFluid));
        }
        return luminance;
    }

    public static int getLuminanceFromItemStack(@NotNull ItemStack stack, boolean submergedInWater) {
        return ItemLightSources.getLuminance(stack, submergedInWater);
    }

    public static RyoamicLights get() {
        if (INSTANCE == null) {
            INSTANCE = new RyoamicLights();
        }
        return INSTANCE;
    }
}

