/*
 * Decompiled with CFR 0.152.
 */
package fuzs.resourcepackoverrides.mixin.client;

import fuzs.resourcepackoverrides.client.data.PackSelectionOverride;
import fuzs.resourcepackoverrides.client.data.ResourceOverridesManager;
import fuzs.resourcepackoverrides.client.gui.screens.packs.PackAwareSelectionEntry;
import java.util.stream.Stream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={PackSelectionScreen.class})
abstract class PackSelectionScreenMixin
extends Screen {
    protected PackSelectionScreenMixin(Component component) {
        super(component);
    }

    @ModifyVariable(method={"updateList"}, at=@At(value="HEAD"))
    private Stream<PackSelectionModel.Entry> updateList(Stream<PackSelectionModel.Entry> models) {
        return models.filter(entry -> {
            if (!(entry instanceof PackAwareSelectionEntry)) {
                return true;
            }
            PackAwareSelectionEntry contextEntry = (PackAwareSelectionEntry)entry;
            PackSelectionOverride override = ResourceOverridesManager.getOverride(contextEntry.getPackId());
            return override.hidden() == null || override.hidden() == false;
        });
    }
}

